/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.building.Building;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;
import net.paradisemod.worldgen.structures.SmallStructure;

public class UndergroundStructure
extends SmallStructure {
    private final ResourceLocation structure;
    private final boolean overGrow;
    private final PMConfig.WorldGenOption settings;

    public UndergroundStructure(String name, boolean overGrow, PMConfig.WorldGenOption settings) {
        this.structure = new ResourceLocation("paradisemod", name);
        this.settings = settings;
        this.overGrow = overGrow;
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        StructureTemplate template;
        Vec3i size;
        int height;
        BlockPos newPos;
        if (this.settings.shouldGenerate(rand) && UndergroundStructure.checkArea(world, newPos = pos.m_175288_(rand.m_216339_(-32, (height = PMCaveFeatures.dimWorldgenLimit(world)) - (size = (template = (StructureTemplate)world.m_6018_().m_215082_().m_230407_(this.structure).get()).m_163801_()).m_123342_())), size)) {
            return this.genStructureFromTemplate(template, world, rand, newPos, generator, this.overGrow);
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        Block[] blockArray;
        int sizeX = template.m_163801_().m_123341_();
        int sizeY = template.m_163801_().m_123342_();
        int sizeZ = template.m_163801_().m_123343_();
        if (rand.m_188499_()) {
            Block[] blockArray2 = new Block[3];
            blockArray2[0] = Blocks.f_50347_;
            blockArray2[1] = Blocks.f_50336_;
            blockArray = blockArray2;
            blockArray2[2] = Blocks.f_50350_;
        } else {
            Block[] blockArray3 = new Block[4];
            blockArray3[0] = Blocks.f_50347_;
            blockArray3[1] = Blocks.f_50340_;
            blockArray3[2] = Blocks.f_50337_;
            blockArray = blockArray3;
            blockArray3[3] = Blocks.f_50350_;
        }
        Block[] carpet = blockArray;
        this.postProcessByBlock(world, template, pos, (curState, curPos) -> {
            BlockState curStateAbove = world.m_8055_(curPos.m_7494_());
            if (PMWorld.isFiller((LevelAccessor)world, curPos, false) || curState.m_60734_() instanceof SignBlock) {
                return;
            }
            if (curState.m_60713_(Blocks.f_49990_) && curStateAbove.m_60713_(Blocks.f_50016_) && rand.m_188503_(7) == 0) {
                world.m_7731_(curPos.m_7494_(), Blocks.f_50196_.m_49966_(), 32);
            }
            if (curState.m_60815_() && curStateAbove.m_60713_(Blocks.f_49990_) && rand.m_188503_(7) == 0) {
                world.m_7731_(curPos.m_7494_(), Blocks.f_50037_.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50652_) && rand.m_188503_(3) == 0) {
                world.m_7731_(curPos, Blocks.f_50079_.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50222_)) {
                if (rand.m_188503_(10) == 0) {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!world.m_8055_(curPos.m_121945_(direction)).m_60795_()) continue;
                        switch (direction) {
                            case EAST: {
                                world.m_7731_(curPos.m_122029_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case WEST: {
                                world.m_7731_(curPos.m_122024_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case NORTH: {
                                world.m_7731_(curPos.m_122012_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case SOUTH: {
                                world.m_7731_(curPos.m_122019_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)), 32);
                            }
                        }
                    }
                }
                switch (rand.m_188503_(3)) {
                    case 0: {
                        world.m_7731_(curPos, Blocks.f_50223_.m_49966_(), 32);
                        break;
                    }
                    case 1: {
                        world.m_7731_(curPos, Blocks.f_50224_.m_49966_(), 32);
                    }
                }
            }
            if (curState.m_60713_(Blocks.f_50336_)) {
                world.m_7731_(curPos, carpet[rand.m_188503_(carpet.length)].m_49966_(), 32);
            }
            if (curState.m_60713_(Building.RED_GLOWING_OBSIDIAN.get())) {
                ITag<Block> glowingObsidian = Utils.getBlockTag(PMTags.Blocks.GLOWING_OBSIDIAN);
                if (glowingObsidian.isEmpty()) {
                    return;
                }
                world.m_7731_(curPos, ((Block)glowingObsidian.getRandomElement(rand).get()).m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50183_) && rand.m_188499_()) {
                world.m_7731_(curPos, Decoration.RUSTED_IRON_BARS.get().m_49966_(), 32);
            }
        });
        PMWorld.updateBlockStates((LevelAccessor)world, pos, sizeX, sizeY, sizeZ);
    }
}

