/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.PMConfig;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.structures.SmallStructure;

public class VillageRuin
extends SmallStructure {
    private static final String[] RUINS = new String[]{"paradisemod:ruins/blacksmith", "paradisemod:ruins/house_1", "paradisemod:ruins/house_2", "paradisemod:ruins/large_house_1", "paradisemod:ruins/large_house_2", "paradisemod:ruins/library", "paradisemod:ruins/well"};

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        PMConfig.WorldGenOption settings = PMConfig.SETTINGS.structures.ruins;
        if (settings.shouldGenerate(rand)) {
            String name = RUINS[rand.m_188503_(RUINS.length)];
            ResourceLocation location = new ResourceLocation(name);
            StructureTemplate template = (StructureTemplate)world.m_6018_().m_215082_().m_230407_(location).get();
            Vec3i size = template.m_163801_();
            if (VillageRuin.checkArea(world, pos, size) && VillageRuin.isFlat(world, pos, size.m_123341_(), size.m_123343_(), false)) {
                if (name.equals("paradisemod:ruins/well")) {
                    return this.genStructureFromTemplate(template, world, rand, pos.m_6625_(12), generator, true);
                }
                return this.genStructureFromTemplate(template, world, rand, pos, generator, true);
            }
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        int sizeX = template.m_163801_().m_123341_();
        int sizeY = template.m_163801_().m_123342_();
        int sizeZ = template.m_163801_().m_123343_();
        Holder biome = world.m_204166_(pos);
        List<Block> wood = VillageRuin.getWood(rand, (Holder<Biome>)biome);
        Block fence = wood.get(0);
        Block fenceGate = wood.get(1);
        Block table = wood.get(2);
        Block log = wood.get(3);
        Block plate = wood.get(4);
        Block planks = wood.get(5);
        Block stairs = wood.get(6);
        Block door = wood.get(7);
        Block bookShelf = wood.get(10);
        this.postProcessByBlock(world, template, pos, (curState, curPos) -> {
            Direction facing;
            BlockState curStateAbove = world.m_8055_(curPos.m_7494_());
            if (curState.m_60713_(Blocks.f_49990_) && curStateAbove.m_60713_(Blocks.f_50016_) && rand.m_188503_(7) == 0) {
                world.m_7731_(curPos.m_7494_(), Blocks.f_50196_.m_49966_(), 32);
            }
            if (curState.m_60815_() && curStateAbove.m_60713_(Blocks.f_49990_) && rand.m_188503_(7) == 0) {
                world.m_7731_(curPos.m_7494_(), Blocks.f_50037_.m_49966_(), 32);
            }
            if (rand.m_188503_(10) == 0 && (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP)) && curState.m_60815_()) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!world.m_8055_(curPos.m_121945_(direction)).m_60795_()) continue;
                    switch (direction) {
                        case EAST: {
                            world.m_7731_(curPos.m_122029_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)), 32);
                            break;
                        }
                        case WEST: {
                            world.m_7731_(curPos.m_122024_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)), 32);
                            break;
                        }
                        case NORTH: {
                            world.m_7731_(curPos.m_122012_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)), 32);
                            break;
                        }
                        case SOUTH: {
                            world.m_7731_(curPos.m_122019_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)), 32);
                        }
                    }
                }
            }
            if (curState.m_60713_(Blocks.f_50154_)) {
                facing = (Direction)curState.m_61143_((Property)DoorBlock.f_52726_);
                Boolean open = (Boolean)curState.m_61143_((Property)DoorBlock.f_52727_);
                DoorHingeSide hinge = (DoorHingeSide)curState.m_61143_((Property)DoorBlock.f_52728_);
                DoubleBlockHalf half = (DoubleBlockHalf)curState.m_61143_((Property)DoorBlock.f_52730_);
                if (half == DoubleBlockHalf.LOWER) {
                    world.m_7731_(curPos, (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 32);
                    world.m_7731_(curPos.m_7494_(), (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
            }
            if (curState.m_60713_(Blocks.f_50086_)) {
                facing = (Direction)curState.m_61143_((Property)StairBlock.f_56841_);
                Half half = (Half)curState.m_61143_((Property)StairBlock.f_56842_);
                StairsShape shape = (StairsShape)curState.m_61143_((Property)StairBlock.f_56843_);
                world.m_7731_(curPos, (BlockState)((BlockState)((BlockState)((BlockState)stairs.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)half)).m_61124_((Property)StairBlock.f_56843_, (Comparable)shape)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 32);
            }
            if (curState.m_60713_(Blocks.f_50705_)) {
                world.m_7731_(curPos, planks.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50078_)) {
                world.m_7731_(curPos, bookShelf.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50167_)) {
                world.m_7731_(curPos, plate.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_49999_)) {
                world.m_7731_(curPos, log.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50091_)) {
                world.m_7731_(curPos, table.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50132_)) {
                world.m_7731_(curPos, fence.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50192_)) {
                facing = (Direction)curState.m_61143_((Property)FenceGateBlock.f_54117_);
                world.m_7731_(curPos, (BlockState)fenceGate.m_49966_().m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)facing), 32);
            }
            if (curState.m_60713_(Blocks.f_50652_) && rand.m_188503_(3) == 0) {
                world.m_7731_(curPos, Blocks.f_50079_.m_49966_(), 32);
            }
            if (world.m_8055_(pos).m_60795_() && rand.m_188503_(5) == 0) {
                world.m_7731_(pos, Blocks.f_50033_.m_49966_(), 32);
            }
        });
        PMWorld.updateBlockStates((LevelAccessor)world, pos, sizeX, sizeY, sizeZ);
    }
}

