/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.Tags;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;

public class BrickDungeonPostProcessor
extends StructurePostProcessor {
    private List<Block> wood = null;

    public BrickDungeonPostProcessor(BlockPos minPos, BlockPos farCorner) {
        super(minPos, farCorner);
    }

    @Override
    protected void postProcessBlock(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockState state, BlockPos blockPos) {
        List<Block> stoneBricks = List.of(Blocks.f_50222_, Blocks.f_50223_, Blocks.f_50224_);
        List<Block> deepslateBricks = List.of(Blocks.f_152589_, Blocks.f_152594_);
        int deepslateLevel = rand.m_188503_(5);
        Holder biome = world.m_204166_(blockPos);
        if (this.wood == null) {
            this.wood = BasicFeature.getWood(rand, (Holder<Biome>)biome);
        }
        if (state.m_60713_(Blocks.f_50705_)) {
            world.m_7731_(blockPos, this.wood.get(5).m_49966_(), 32);
        }
        if (state.m_60713_(Blocks.f_50132_)) {
            Block fence = this.wood.get(0);
            Boolean north = (Boolean)state.m_61143_((Property)FenceBlock.f_52309_);
            Boolean south = (Boolean)state.m_61143_((Property)FenceBlock.f_52311_);
            Boolean east = (Boolean)state.m_61143_((Property)FenceBlock.f_52310_);
            Boolean west = (Boolean)state.m_61143_((Property)FenceBlock.f_52312_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fence.m_49966_().m_61124_((Property)FenceBlock.f_52309_, (Comparable)north)).m_61124_((Property)FenceBlock.f_52311_, (Comparable)south)).m_61124_((Property)FenceBlock.f_52310_, (Comparable)east)).m_61124_((Property)FenceBlock.f_52312_, (Comparable)west)).m_61124_((Property)FenceBlock.f_52313_, (Comparable)Boolean.valueOf(false)), 32);
        }
        if (state.m_60713_(Blocks.f_50375_)) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 32);
        }
        if (state.m_60713_(Blocks.f_50652_) && rand.m_188499_()) {
            world.m_7731_(blockPos, Blocks.f_50079_.m_49966_(), 32);
        } else if (state.m_204336_(BlockTags.f_13091_) && biome.m_203565_(Biomes.f_220594_)) {
            world.m_7731_(blockPos, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get().m_49966_(), 32);
        } else if (state.m_60713_(Blocks.f_50215_)) {
            world.m_7731_(blockPos, Blocks.f_50058_.m_49966_(), 2);
            for (Direction direction : Direction.values()) {
                BlockState adjBlock = world.m_8055_(blockPos.m_121945_(direction));
                if (adjBlock.m_60713_(Blocks.f_152550_) || adjBlock.m_60713_(Blocks.f_152551_)) {
                    world.m_7731_(blockPos, deepslateBricks.get(rand.m_188503_(2)).m_49966_(), 2);
                } else if (adjBlock.m_204336_(Tags.Blocks.STONE) || adjBlock.m_204336_(Tags.Blocks.GRAVEL) || adjBlock.m_204336_(Tags.Blocks.ORES)) {
                    world.m_7731_(blockPos, stoneBricks.get(rand.m_188503_(3)).m_49966_(), 2);
                } else {
                    if (!adjBlock.m_204336_(BlockTags.f_144274_)) continue;
                    world.m_7731_(blockPos, Blocks.f_220844_.m_49966_(), 2);
                }
                break;
            }
        } else if (blockPos.m_123342_() <= deepslateLevel) {
            if (state.m_204336_(BlockTags.f_13091_)) {
                world.m_7731_(blockPos, deepslateBricks.get(rand.m_188503_(2)).m_49966_(), 2);
            } else if (state.m_60713_(Blocks.f_50411_)) {
                world.m_7731_(blockPos, (BlockState)Blocks.f_152591_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 2);
            }
        }
    }
}

