/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.paradisemod.building.Doors;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.decoration.Tables;
import net.paradisemod.misc.Chests;
import net.paradisemod.misc.tile.CustomChestEntity;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;

public class DarkDungeonPostProcessor
extends StructurePostProcessor {
    private List<Block> wood = null;

    public DarkDungeonPostProcessor(BlockPos minPos, BlockPos farCorner) {
        super(minPos, farCorner);
    }

    @Override
    protected void postProcessBlock(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockState state, BlockPos blockPos) {
        List<Block> deepslateBricks = List.of(Blocks.f_152589_, Blocks.f_152594_);
        Holder biome = world.m_204166_(blockPos);
        if (this.wood == null) {
            this.wood = BasicFeature.getWood(rand, (Holder<Biome>)biome);
        }
        Block chest = this.wood.get(8);
        Block table = this.wood.get(2);
        Block door = this.wood.get(7);
        Block bookshelf = this.wood.get(10);
        if (state.m_60713_(Blocks.f_50215_) || state.m_60713_(DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get())) {
            boolean hasAdjStone = false;
            for (Direction direction : Direction.values()) {
                BlockState adjBlock = world.m_8055_(blockPos.m_121945_(direction));
                if (adjBlock.m_60713_(Blocks.f_152550_) || adjBlock.m_60713_(Blocks.f_152551_)) {
                    hasAdjStone = true;
                    world.m_7731_(blockPos, deepslateBricks.get(rand.m_188503_(2)).m_49966_(), 2);
                    break;
                }
                if (!adjBlock.m_60713_(DeepDarkBlocks.DARKSTONE.get())) continue;
                hasAdjStone = true;
                world.m_7731_(blockPos, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get().m_49966_(), 2);
                break;
            }
            if (!hasAdjStone && state.m_60713_(Blocks.f_50215_)) {
                world.m_7731_(blockPos, Blocks.f_50058_.m_49966_(), 2);
            }
        } else if (state.m_60713_(Blocks.f_50211_)) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
            ConfiguredFeature sculkPatch = (ConfiguredFeature)this.getFeature(CaveFeatures.f_236675_).m_203334_();
            sculkPatch.m_224953_(world, generator, rand, blockPos);
        } else if (world.m_8055_(blockPos).m_60713_(Chests.BLACKENED_OAK_CHEST)) {
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            BlockEntity tile = world.m_7702_(blockPos);
            if (tile instanceof CustomChestEntity) {
                CustomChestEntity chestTile = (CustomChestEntity)tile;
                ResourceLocation lootTable = chestTile.getLootTable();
                world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 32);
                world.m_7731_(blockPos, (BlockState)((BlockState)chest.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)type), 32);
                BlockEntity newTile = world.m_7702_(blockPos);
                if (newTile instanceof CustomChestEntity) {
                    CustomChestEntity newChestTile = (CustomChestEntity)newTile;
                    newChestTile.m_59626_(lootTable, rand.m_188505_());
                }
            }
        } else if (state.m_60713_(Doors.BLACKENED_OAK_DOOR.get())) {
            Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            Boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)half), 32);
        } else if (state.m_60713_(Tables.BLACKENED_OAK_CRAFTING_TABLE.get())) {
            world.m_7731_(blockPos, table.m_49966_(), 32);
        } else if (state.m_60713_(Decoration.BLACKENED_OAK_BOOKSHELF.get())) {
            world.m_7731_(blockPos, bookshelf.m_49966_(), 32);
        }
    }
}

