/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.monsters.Monsters;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;

public class MonasteryPostProcessor
extends StructurePostProcessor {
    public static final List<Block> NEUTRAL_PANES = List.of(Blocks.f_50303_, Blocks.f_50364_, Blocks.f_50363_, Blocks.f_50371_);
    private List<Block> wood = null;
    private List<Block> coloredBlocks = null;

    public MonasteryPostProcessor(BlockPos minPos, BlockPos farCorner) {
        super(minPos, farCorner);
    }

    @Override
    protected void postProcessBlock(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockState state, BlockPos blockPos) {
        boolean isLush;
        Holder biome = world.m_204166_(blockPos);
        if (this.wood == null) {
            this.wood = BasicFeature.getWood(rand, (Holder<Biome>)biome);
        }
        if (this.coloredBlocks == null) {
            this.coloredBlocks = MonasteryPostProcessor.coloredGlassAndCandles(rand, (Holder<Biome>)biome);
        }
        boolean bl = isLush = biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP);
        if (state.m_60713_(Blocks.f_50222_)) {
            if (rand.m_188503_(20) == 0) {
                world.m_7731_(blockPos, Blocks.f_50224_.m_49966_(), 32);
            } else if (rand.m_188503_(20) == 0 && isLush) {
                world.m_7731_(blockPos, Blocks.f_50223_.m_49966_(), 32);
            }
        } else if (state.m_60713_(Blocks.f_152589_) && rand.m_188503_(20) == 0) {
            world.m_7731_(blockPos, Blocks.f_152594_.m_49966_(), 32);
        } else if (state.m_60713_(Blocks.f_50194_) && rand.m_188503_(20) == 0 && isLush) {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)Blocks.f_50631_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)half)).m_61124_((Property)StairBlock.f_56843_, (Comparable)shape), 32);
        } else if (state.m_60713_(Blocks.f_50609_) && rand.m_188503_(20) == 0 && isLush) {
            WallSide north = (WallSide)state.m_61143_((Property)WallBlock.f_57951_);
            WallSide south = (WallSide)state.m_61143_((Property)WallBlock.f_57952_);
            WallSide east = (WallSide)state.m_61143_((Property)WallBlock.f_57950_);
            WallSide west = (WallSide)state.m_61143_((Property)WallBlock.f_57953_);
            boolean up = (Boolean)state.m_61143_((Property)WallBlock.f_57949_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50607_.m_49966_().m_61124_((Property)WallBlock.f_57951_, (Comparable)north)).m_61124_((Property)WallBlock.f_57952_, (Comparable)south)).m_61124_((Property)WallBlock.f_57950_, (Comparable)east)).m_61124_((Property)WallBlock.f_57953_, (Comparable)west)).m_61124_((Property)WallBlock.f_57949_, (Comparable)Boolean.valueOf(up)), 32);
        } else if (state.m_60713_(Blocks.f_50185_)) {
            boolean north = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52309_);
            boolean south = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52311_);
            boolean east = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52310_);
            boolean west = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52312_);
            ITag<Block> stainedGlass = Utils.getBlockTag((TagKey<Block>)Tags.Blocks.STAINED_GLASS_PANES);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((Block)stainedGlass.getRandomElement(rand).get()).m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(west)), 32);
        } else if (state.m_60713_(Blocks.f_50371_)) {
            boolean north = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52309_);
            boolean south = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52311_);
            boolean east = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52310_);
            boolean west = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52312_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)NEUTRAL_PANES.get(rand.m_188503_(NEUTRAL_PANES.size())).m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(west)), 32);
        } else if (state.m_60713_(Blocks.f_50307_)) {
            boolean north = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52309_);
            boolean south = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52311_);
            boolean east = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52310_);
            boolean west = (Boolean)state.m_61143_((Property)IronBarsBlock.f_52312_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)this.coloredBlocks.get(0).m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(west)), 32);
        } else if (state.m_60713_(Blocks.f_152513_)) {
            world.m_7731_(blockPos, (BlockState)((BlockState)this.coloredBlocks.get(1).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(4))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true)), 32);
        } else if (state.m_60713_(Blocks.f_50086_)) {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)this.wood.get(6).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)half)).m_61124_((Property)StairBlock.f_56843_, (Comparable)shape), 32);
        } else if (state.m_60713_(Blocks.f_50154_)) {
            Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            Boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)this.wood.get(7).m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)half), 32);
        } else if (state.m_60713_(Blocks.f_50681_)) {
            world.m_7731_(blockPos, (BlockState)BasicFeature.getColoredBlocks(rand, (Holder<Biome>)biome).get(1).m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)), 32);
        } else if (state.m_60713_(Trapdoors.SILVER_TRAPDOOR.get())) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 16);
            this.placeMobAtPos(world, Monsters.WEREWOLF_ILLAGER.get(), blockPos);
        }
    }

    public static List<Block> coloredGlassAndCandles(RandomSource rand, Holder<Biome> biome) {
        List<Block> roseFieldBlocks = MonasteryPostProcessor.roseGlassAndCandles(PMBiomes.ROSE_FIELDS_BY_COLOR, biome);
        List<Block> roseLandBlocks = MonasteryPostProcessor.roseGlassAndCandles(PMBiomes.ROSE_LANDS_BY_COLOR, biome);
        if (!roseFieldBlocks.isEmpty()) {
            return roseFieldBlocks;
        }
        if (!roseLandBlocks.isEmpty()) {
            return roseLandBlocks;
        }
        Block glassPane = Blocks.f_50370_;
        Block candle = Blocks.f_152523_;
        if (biome.m_203565_(PMBiomes.GLOWING_FOREST) || biome.m_203565_(PMBiomes.CRYSTAL_FOREST)) {
            glassPane = Blocks.f_50364_;
            candle = Blocks.f_152517_;
        } else if (biome.m_203565_(Biomes.f_48151_) || biome.m_203565_(PMBiomes.UNDERGROUND_DARK_FOREST)) {
            glassPane = Blocks.f_50367_;
            candle = Blocks.f_152520_;
        } else if (biome.m_203565_(PMBiomes.WEEPING_FOREST) || biome.m_203565_(PMBiomes.FROZEN_WEEPING_FOREST)) {
            glassPane = Blocks.f_50363_;
            candle = Blocks.f_152516_;
        } else if (biome.m_203656_(BiomeTags.f_207607_) || PMBiomes.isRockyDesert(biome)) {
            glassPane = Blocks.f_50368_;
            candle = Blocks.f_152521_;
        } else if (biome.m_203565_(Biomes.f_48149_) || biome.m_203565_(Biomes.f_186762_) || biome.m_203565_(PMBiomes.UNDERGROUND_BIRCH_FOREST)) {
            glassPane = Blocks.f_50365_;
            candle = Blocks.f_152518_;
        } else if (biome.m_203565_(Biomes.f_271432_) || biome.m_203565_(PMBiomes.UNDERGROUND_CHERRY_FOREST)) {
            glassPane = Blocks.f_50362_;
            candle = Blocks.f_152515_;
        } else if (biome.m_203565_(PMBiomes.AUTUMN_FOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST)) {
            switch (rand.m_188503_(4)) {
                case 0: {
                    glassPane = Blocks.f_50307_;
                    candle = Blocks.f_152513_;
                    break;
                }
                case 1: {
                    glassPane = Blocks.f_50304_;
                    candle = Blocks.f_152484_;
                    break;
                }
                case 2: {
                    glassPane = Blocks.f_50370_;
                    candle = Blocks.f_152523_;
                    break;
                }
                case 3: {
                    glassPane = Blocks.f_50367_;
                    candle = Blocks.f_152520_;
                }
            }
        } else if (biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203565_(PMBiomes.TEMPERATE_RAINFOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST)) {
            glassPane = Blocks.f_50369_;
            candle = Blocks.f_152522_;
        } else if (biome.m_203565_(Biomes.f_220594_) || biome.m_203656_(PMTags.Biomes.DEEP_DARK)) {
            glassPane = Blocks.f_50371_;
            candle = Blocks.f_152524_;
        } else if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) || biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            glassPane = Blocks.f_50306_;
            candle = Blocks.f_152512_;
        } else if (biome.m_203656_(BiomeTags.f_207610_)) {
            glassPane = Blocks.f_50361_;
            candle = Blocks.f_152514_;
        } else if (biome.m_203656_(BiomeTags.f_215816_)) {
            glassPane = Blocks.f_50304_;
            candle = Blocks.f_152484_;
        } else if (biome.m_203656_(Tags.Biomes.IS_DRY)) {
            glassPane = Blocks.f_50307_;
            candle = Blocks.f_152513_;
        }
        return List.of(glassPane, candle);
    }

    private static List<Block> roseGlassAndCandles(EnumMap<DyeColor, ResourceKey<Biome>> roseBiomes, Holder<Biome> biome) {
        Block glassPane = Blocks.f_50370_;
        Block candle = Blocks.f_152523_;
        for (Map.Entry<DyeColor, ResourceKey<Biome>> entry : roseBiomes.entrySet()) {
            DyeColor color = entry.getKey();
            ResourceKey<Biome> roseBiome = entry.getValue();
            if (!biome.m_203565_(roseBiome)) continue;
            switch (color) {
                case WHITE: {
                    glassPane = Blocks.f_50303_;
                    candle = Blocks.f_152483_;
                    break;
                }
                case ORANGE: {
                    glassPane = Blocks.f_50304_;
                    candle = Blocks.f_152484_;
                    break;
                }
                case MAGENTA: {
                    glassPane = Blocks.f_50305_;
                    candle = Blocks.f_152511_;
                    break;
                }
                case LIGHT_BLUE: {
                    glassPane = Blocks.f_50306_;
                    candle = Blocks.f_152512_;
                    break;
                }
                case YELLOW: {
                    glassPane = Blocks.f_50307_;
                    candle = Blocks.f_152513_;
                    break;
                }
                case LIME: {
                    glassPane = Blocks.f_50361_;
                    candle = Blocks.f_152514_;
                    break;
                }
                case PINK: {
                    glassPane = Blocks.f_50362_;
                    candle = Blocks.f_152515_;
                    break;
                }
                case GRAY: {
                    glassPane = Blocks.f_50363_;
                    candle = Blocks.f_152516_;
                    break;
                }
                case LIGHT_GRAY: {
                    glassPane = Blocks.f_50364_;
                    candle = Blocks.f_152517_;
                    break;
                }
                case CYAN: {
                    glassPane = Blocks.f_50365_;
                    candle = Blocks.f_152518_;
                    break;
                }
                case PURPLE: {
                    glassPane = Blocks.f_50366_;
                    candle = Blocks.f_152519_;
                    break;
                }
                case BLUE: {
                    glassPane = Blocks.f_50367_;
                    candle = Blocks.f_152520_;
                    break;
                }
                case BROWN: {
                    glassPane = Blocks.f_50368_;
                    candle = Blocks.f_152521_;
                    break;
                }
                case GREEN: {
                    glassPane = Blocks.f_50369_;
                    candle = Blocks.f_152522_;
                    break;
                }
                case BLACK: {
                    glassPane = Blocks.f_50371_;
                    candle = Blocks.f_152524_;
                }
            }
            return List.of(glassPane, candle);
        }
        return List.of();
    }
}

