/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.paradisemod.base.PMConfig;

public abstract class StructurePostProcessor {
    protected final BlockPos minPos;
    protected final BlockPos farCorner;
    private Registry<PlacedFeature> placedFeatureRegistry;
    private Registry<ConfiguredFeature<?, ?>> featureRegistry;

    protected StructurePostProcessor(BlockPos minPos, BlockPos farCorner) {
        this.minPos = minPos;
        this.farCorner = farCorner;
    }

    public final void run(WorldGenLevel world, ChunkGenerator generator, RandomSource rand) {
        this.placedFeatureRegistry = world.m_6018_().m_9598_().m_175515_(Registries.f_256988_);
        this.featureRegistry = world.m_6018_().m_9598_().m_175515_(Registries.f_256911_);
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)this.minPos, (BlockPos)this.farCorner)) {
            BlockState state = world.m_8055_(blockPos);
            if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                world.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 16);
            }
            this.postProcessBlock(world, generator, rand, world.m_8055_(blockPos), blockPos);
            if (!state.m_60795_() || !((Boolean)PMConfig.SETTINGS.structures.debugMode.get()).booleanValue()) continue;
            world.m_7731_(blockPos, Blocks.f_50058_.m_49966_(), 16);
        }
        if (((Boolean)PMConfig.SETTINGS.structures.debugMode.get()).booleanValue()) {
            world.m_7731_(this.minPos, Blocks.f_50205_.m_49966_(), 16);
            world.m_7731_(this.farCorner, Blocks.f_50205_.m_49966_(), 16);
        }
    }

    protected abstract void postProcessBlock(WorldGenLevel var1, ChunkGenerator var2, RandomSource var3, BlockState var4, BlockPos var5);

    protected final Holder<PlacedFeature> getPlacedFeature(ResourceKey<PlacedFeature> key) {
        return this.placedFeatureRegistry.m_246971_(key);
    }

    protected final Holder<ConfiguredFeature<?, ?>> getFeature(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return this.featureRegistry.m_246971_(key);
    }

    protected final <T extends Mob> void placeMobAtPos(WorldGenLevel world, EntityType<T> mobType, BlockPos mobPos) {
        Mob mob = (Mob)mobType.m_20615_((Level)world.m_6018_());
        mob.m_7678_((double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5, 0.0f, 0.0f);
        ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)world, (DifficultyInstance)world.m_6436_(this.minPos), (MobSpawnType)MobSpawnType.STRUCTURE, null, null);
        world.m_47205_((Entity)mob);
    }

    protected final <T extends Mob> void placeMobAtPos(WorldGenLevel world, T mob, BlockPos mobPos) {
        mob.m_7678_((double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5, 0.0f, 0.0f);
        ForgeEventFactory.onFinalizeSpawn(mob, (ServerLevelAccessor)world, (DifficultyInstance)world.m_6436_(this.minPos), (MobSpawnType)MobSpawnType.STRUCTURE, null, null);
        world.m_47205_(mob);
    }

    @FunctionalInterface
    public static interface Constructor {
        public StructurePostProcessor construct(BlockPos var1, BlockPos var2);
    }
}

