/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.foliage.PMFoliage;
import net.paradisemod.worldgen.structures.postprocessors.BrickDungeonPostProcessor;

public class TerrariumPostProcessor
extends BrickDungeonPostProcessor {
    private static final List<EntityType<? extends Mob>> ANIMALS = List.of(EntityType.f_20557_, EntityType.f_20520_, EntityType.f_20510_, EntityType.f_20555_);
    private List<Block> wood = null;
    private List<Block> coloredBlocks = null;

    public TerrariumPostProcessor(BlockPos minPos, BlockPos farCorner) {
        super(minPos, farCorner);
    }

    @Override
    protected void postProcessBlock(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockState state, BlockPos blockPos) {
        List<Block> deepslateBricks = List.of(Blocks.f_152589_, Blocks.f_152594_);
        Holder biome = world.m_204166_(this.minPos);
        List<Block> grasses = List.of(Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50359_);
        ITag<Block> flowers = Utils.getBlockTag((TagKey<Block>)BlockTags.f_13041_);
        int deepslateLevel = rand.m_188503_(5);
        if (this.coloredBlocks == null) {
            this.coloredBlocks = BasicFeature.getColoredBlocks(rand, (Holder<Biome>)biome);
        }
        Block lantern = this.coloredBlocks.get(1);
        Block lamp = this.coloredBlocks.get(2);
        Block bed = this.coloredBlocks.get(3);
        if (this.wood == null) {
            this.wood = BasicFeature.getWood(rand, (Holder<Biome>)biome);
        }
        Block table = this.wood.get(2);
        Block door = this.wood.get(7);
        Block strippedLog = this.wood.get(11);
        Block slab = this.wood.get(12);
        if (state.m_60713_(Blocks.f_50440_)) {
            BlockPos posAbove = blockPos.m_7494_();
            if (rand.m_188503_(10) == 0 && rand.m_188499_()) {
                Block flower = (Block)flowers.getRandomElement(rand).get();
                if (flower != Blocks.f_50070_) {
                    world.m_7731_(posAbove, flower.m_49966_(), 32);
                }
                if (flower.m_49966_().m_61138_((Property)BlockStateProperties.f_61401_)) {
                    world.m_7731_(posAbove.m_7494_(), (BlockState)flower.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
            } else if (rand.m_188499_()) {
                Block grass = grasses.get(rand.m_188503_(3));
                world.m_7731_(posAbove, grass.m_49966_(), 2);
                if (grass.m_49966_().m_61138_((Property)BlockStateProperties.f_61401_)) {
                    world.m_7731_(posAbove.m_7494_(), (BlockState)grass.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
            } else if (rand.m_188503_(20) == 0) {
                this.placeBiomeTree(world, generator, rand, posAbove);
            }
        } else if (state.m_60713_(Blocks.f_50093_)) {
            List<Block> crops = List.of(Blocks.f_50249_, Blocks.f_50250_, Blocks.f_50092_, Blocks.f_50444_);
            Block crop = crops.get(rand.m_188503_(4));
            if (crop instanceof BeetrootBlock) {
                world.m_7731_(blockPos.m_7494_(), (BlockState)crop.m_49966_().m_61124_((Property)BeetrootBlock.f_49657_, (Comparable)Integer.valueOf(rand.m_188503_(3))), 32);
            } else {
                world.m_7731_(blockPos.m_7494_(), (BlockState)crop.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(rand.m_188503_(7))), 32);
            }
        } else if (state.m_204336_(BlockTags.f_13091_)) {
            if (biome.m_203565_(Biomes.f_220594_)) {
                world.m_7731_(blockPos, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get().m_49966_(), 2);
            } else if (blockPos.m_123342_() <= deepslateLevel) {
                world.m_7731_(blockPos, deepslateBricks.get(rand.m_188503_(2)).m_49966_(), 2);
            } else if (biome.m_203656_(BiomeTags.f_207603_)) {
                for (Direction direction : Direction.values()) {
                    BlockState adjBlock = world.m_8055_(blockPos.m_121945_(direction));
                    if (!adjBlock.m_60713_(Blocks.f_49990_)) continue;
                    world.m_7731_(blockPos, Blocks.f_50378_.m_49966_(), 2);
                    break;
                }
            } else {
                List<Block> stoneBricks = List.of(Blocks.f_50222_, Blocks.f_50223_, Blocks.f_50224_);
                world.m_7731_(blockPos, stoneBricks.get(rand.m_188503_(stoneBricks.size())).m_49966_(), 2);
            }
        } else if (state.m_60713_(Trapdoors.EMERALD_TRAPDOOR.get())) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 16);
            for (int x = 0; x < 8; ++x) {
                this.placeMobAtPos(world, new Villager(EntityType.f_20492_, (Level)world.m_6018_(), TerrariumPostProcessor.getVillagerType((Holder<Biome>)world.m_204166_(this.minPos))), blockPos);
            }
        } else if (state.m_60713_(Trapdoors.STONE_TRAPDOOR.get())) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 16);
            for (int x = 0; x < 4; ++x) {
                this.placeMobAtPos(world, ANIMALS.get(rand.m_188503_(ANIMALS.size())), blockPos);
            }
        } else if (state.m_60713_(Blocks.f_50091_)) {
            world.m_7731_(blockPos, table.m_49966_(), 2);
        } else if (state.m_60713_(Blocks.f_50398_)) {
            SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            world.m_7731_(blockPos, (BlockState)((BlockState)slab.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)type)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 2);
        } else if (state.m_60713_(Blocks.f_50154_)) {
            Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            Boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)half), 2);
        } else if (state.m_60713_(Blocks.f_50261_)) {
            world.m_7731_(blockPos, (BlockState)lamp.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true)), 2);
        } else if (state.m_60713_(Blocks.f_50681_)) {
            world.m_7731_(blockPos, lantern.m_49966_(), 2);
        } else if (state.m_60713_(Blocks.f_50028_)) {
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            BedPart part = (BedPart)state.m_61143_((Property)BedBlock.f_49440_);
            world.m_7731_(blockPos, (BlockState)((BlockState)bed.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)part)).m_61124_((Property)BedBlock.f_54117_, (Comparable)facing), 2);
        } else if (state.m_60713_(Blocks.f_50010_)) {
            world.m_7731_(blockPos, strippedLog.m_49966_(), 2);
        }
        super.postProcessBlock(world, generator, rand, state, blockPos);
    }

    private static VillagerType getVillagerType(Holder<Biome> biome) {
        if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            return VillagerType.f_35824_;
        }
        if (biome.m_203656_(Tags.Biomes.IS_HOT)) {
            if (biome.m_203656_(BiomeTags.f_215816_)) {
                return VillagerType.f_35822_;
            }
            if (biome.m_203656_(Tags.Biomes.IS_DRY)) {
                return VillagerType.f_35819_;
            }
            return VillagerType.f_35820_;
        }
        if (biome.m_203656_(Tags.Biomes.IS_COLD)) {
            if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS)) {
                return VillagerType.f_35825_;
            }
            return VillagerType.f_35823_;
        }
        return VillagerType.f_35821_;
    }

    private void placeBiomeTree(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos blockPos) {
        ResourceKey tree;
        Holder biome = world.m_204166_(this.minPos);
        Object object = tree = rand.m_188499_() ? TreePlacements.f_195374_ : TreePlacements.f_195376_;
        if (biome.m_203656_(Tags.Biomes.IS_HOT)) {
            tree = biome.m_203656_(BiomeTags.f_215816_) ? TreePlacements.f_195377_ : TreePlacements.f_195384_;
        } else if (biome.m_203565_(Biomes.f_48151_) || biome.m_203565_(PMBiomes.UNDERGROUND_DARK_FOREST)) {
            tree = TreePlacements.f_195375_;
        } else if (biome.m_203565_(Biomes.f_48149_) || biome.m_203565_(Biomes.f_186762_) || biome.m_203565_(PMBiomes.UNDERGROUND_BIRCH_FOREST)) {
            tree = TreePlacements.f_195376_;
        } else if (biome.m_203565_(PMBiomes.AUTUMN_FOREST)) {
            List<ResourceKey<PlacedFeature>> trees = PMFoliage.allAutumnTrees();
            tree = trees.get(rand.m_188503_(trees.size()));
        } else if (biome.m_203656_(Tags.Biomes.IS_COLD)) {
            tree = TreePlacements.f_195378_;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState nearState = world.m_8055_(blockPos.m_121945_(dir));
            BlockState farState = world.m_8055_(blockPos.m_5484_(dir, 2));
            if (!nearState.m_204336_(BlockTags.f_13106_) && !farState.m_204336_(BlockTags.f_13106_)) continue;
            return;
        }
        if (((PlacedFeature)this.getPlacedFeature((ResourceKey<PlacedFeature>)tree).m_203334_()).m_226357_(world, generator, rand, blockPos)) {
            world.m_7731_(blockPos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
    }
}

