/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.postprocessors;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;

public class TraderTentPostProcessor
extends StructurePostProcessor {
    private List<Block> wood = null;
    private List<Block> coloredBlocks = null;

    public TraderTentPostProcessor(BlockPos minPos, BlockPos farCorner) {
        super(minPos, farCorner);
    }

    @Override
    protected void postProcessBlock(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockState state, BlockPos blockPos) {
        Holder biome = world.m_204166_(blockPos);
        if (this.wood == null) {
            this.wood = BasicFeature.getWood(rand, (Holder<Biome>)biome);
        }
        if (this.coloredBlocks == null) {
            this.coloredBlocks = BasicFeature.getColoredBlocks(rand, (Holder<Biome>)biome);
        }
        Block fence = this.wood.get(0);
        Block fenceGate = this.wood.get(1);
        Block wool = this.coloredBlocks.get(0);
        Block lantern = this.coloredBlocks.get(1);
        Block craftingTable = this.wood.get(2);
        Block bed = this.coloredBlocks.get(3);
        if (state.m_60713_(Trapdoors.GLASS_TRAPDOOR.get())) {
            TraderLlama llama1 = (TraderLlama)EntityType.f_20488_.m_20615_((Level)world.m_6018_());
            TraderLlama llama2 = (TraderLlama)EntityType.f_20488_.m_20615_((Level)world.m_6018_());
            llama1.m_149555_(Integer.MAX_VALUE);
            llama2.m_149555_(Integer.MAX_VALUE);
            this.placeMobAtPos(world, llama1, blockPos);
            this.placeMobAtPos(world, llama2, blockPos);
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 32);
        } else if (state.m_60713_(Blocks.f_50216_)) {
            WanderingTrader trader = (WanderingTrader)EntityType.f_20494_.m_20615_((Level)world.m_6018_());
            trader.m_35891_(-1);
            this.placeMobAtPos(world, trader, blockPos);
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 32);
        } else if (state.m_60713_(Blocks.f_50108_)) {
            List<Block> nWools = List.of(Blocks.f_50041_, Blocks.f_50102_, Blocks.f_50101_, Blocks.f_50109_);
            world.m_7731_(blockPos, (rand.m_188503_(4) == 0 ? nWools.get(rand.m_188503_(4)) : wool).m_49966_(), 32);
        } else if (state.m_60713_(Blocks.f_50681_)) {
            world.m_7731_(blockPos, (BlockState)lantern.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)), 32);
        } else if (world.m_8055_(blockPos).m_60713_(Blocks.f_50028_)) {
            BedPart part = (BedPart)world.m_8055_(blockPos).m_61143_((Property)BedBlock.f_49440_);
            Direction bedDir = (Direction)world.m_8055_(blockPos).m_61143_((Property)BedBlock.f_54117_);
            world.m_7731_(blockPos, (BlockState)((BlockState)bed.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)part)).m_61124_((Property)BedBlock.f_54117_, (Comparable)bedDir), 32);
        } else if (world.m_8055_(blockPos).m_60713_(Blocks.f_50132_)) {
            Boolean north = (Boolean)state.m_61143_((Property)FenceBlock.f_52309_);
            Boolean south = (Boolean)state.m_61143_((Property)FenceBlock.f_52311_);
            Boolean east = (Boolean)state.m_61143_((Property)FenceBlock.f_52310_);
            Boolean west = (Boolean)state.m_61143_((Property)FenceBlock.f_52312_);
            world.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fence.m_49966_().m_61124_((Property)FenceBlock.f_52309_, (Comparable)north)).m_61124_((Property)FenceBlock.f_52311_, (Comparable)south)).m_61124_((Property)FenceBlock.f_52310_, (Comparable)east)).m_61124_((Property)FenceBlock.f_52312_, (Comparable)west)).m_61124_((Property)FenceBlock.f_52313_, (Comparable)Boolean.valueOf(false)), 32);
        } else if (world.m_8055_(blockPos).m_60713_(Blocks.f_50192_)) {
            Direction gateDir = (Direction)world.m_8055_(blockPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            world.m_7731_(blockPos, (BlockState)fenceGate.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)gateDir), 1);
        } else if (world.m_8055_(blockPos).m_60713_(Blocks.f_50091_)) {
            world.m_7731_(blockPos, craftingTable.m_49966_(), 8);
        }
    }
}

