/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.processors;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.automation.Automation;
import net.paradisemod.worldgen.structures.PMStructures;
import org.jetbrains.annotations.Nullable;

public class BrickDungeonProcessor
extends StructureProcessor {
    public static final Codec<BrickDungeonProcessor> CODEC = Codec.unit(BrickDungeonProcessor::new);

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos structPos, BlockPos blockPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, StructureTemplate template) {
        BlockState state = relativeBlockInfo.f_74676_();
        BlockPos worldPos = relativeBlockInfo.f_74675_();
        RandomSource rand = settings.m_230326_(relativeBlockInfo.f_74675_());
        CompoundTag nbt = relativeBlockInfo.f_74677_();
        List<Block> stoneBricks = List.of(Blocks.f_50222_, Blocks.f_50223_, Blocks.f_50224_);
        if (state.m_60713_(Blocks.f_50222_)) {
            state = stoneBricks.get(rand.m_188503_(3)).m_49966_();
        } else if (state.m_60713_(Blocks.f_50094_) && rand.m_188499_()) {
            Direction facing = (Direction)state.m_61143_((Property)FurnaceBlock.f_48683_);
            state = (BlockState)Automation.MOSSY_COBBLESTONE_FURNACE.get().m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)facing);
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, state, nbt);
    }

    protected StructureProcessorType<BrickDungeonProcessor> m_6953_() {
        return (StructureProcessorType)PMStructures.BRICK_DUNGEON_PROCESSOR.get();
    }
}

