/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.processors;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.worldgen.structures.PMStructures;

public class DarkDungeonProcessor
extends StructureProcessor {
    public static final Codec<DarkDungeonProcessor> CODEC = Codec.unit(DarkDungeonProcessor::new);
    public static final List<Block> ALL_CONCRETE = List.of(Blocks.f_50505_, Blocks.f_50502_, Blocks.f_50504_, Blocks.f_50543_, Blocks.f_50494_, Blocks.f_50495_, Blocks.f_50503_, Blocks.f_50499_, Blocks.f_50545_, Blocks.f_50501_, Blocks.f_50500_, Blocks.f_50544_, Blocks.f_50496_);
    @Nullable
    private ConcreteColors colors = null;

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos structPos, BlockPos blockPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, StructureTemplate template) {
        BlockPos worldPos = relativeBlockInfo.f_74675_();
        RandomSource rand = settings.m_230326_(relativeBlockInfo.f_74675_());
        if (this.colors == null) {
            ConcreteColors[] allSchemes = ConcreteColors.values();
            this.colors = allSchemes[rand.m_188503_(allSchemes.length)];
        }
        BlockState state = relativeBlockInfo.f_74676_();
        CompoundTag nbt = relativeBlockInfo.f_74677_();
        if (state.m_60713_(Blocks.f_50542_)) {
            state = this.colors.getConcrete(rand).m_49966_();
        } else if (state.m_60713_(Blocks.f_50183_) && rand.m_188499_()) {
            Boolean east = (Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_);
            Boolean west = (Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_);
            Boolean north = (Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_);
            Boolean south = (Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_);
            state = (BlockState)((BlockState)((BlockState)((BlockState)Decoration.RUSTED_IRON_BARS.get().m_49966_().m_61124_((Property)CrossCollisionBlock.f_52310_, (Comparable)east)).m_61124_((Property)CrossCollisionBlock.f_52312_, (Comparable)west)).m_61124_((Property)CrossCollisionBlock.f_52309_, (Comparable)north)).m_61124_((Property)CrossCollisionBlock.f_52311_, (Comparable)south);
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, state, nbt);
    }

    protected StructureProcessorType<DarkDungeonProcessor> m_6953_() {
        return (StructureProcessorType)PMStructures.DARK_DUNGEON_PROCESSOR.get();
    }

    private static enum ConcreteColors {
        RED_WHITE_BLUE,
        ARIZONA_COLORS,
        ALL;


        private Block getConcrete(RandomSource rand) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case RED_WHITE_BLUE -> {
                    Block[] concrete = new Block[]{Blocks.f_50504_, Blocks.f_50542_, Blocks.f_50501_};
                    yield concrete[rand.m_188503_(3)];
                }
                case ARIZONA_COLORS -> {
                    Block[] concrete = new Block[]{Blocks.f_50504_, Blocks.f_50501_, Blocks.f_50494_, Blocks.f_50543_};
                    yield concrete[rand.m_188503_(4)];
                }
                case ALL -> ALL_CONCRETE.get(rand.m_188503_(ALL_CONCRETE.size()));
            };
        }
    }
}

