/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures.processors;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.misc.Misc;
import net.paradisemod.worldgen.structures.PMStructures;
import org.jetbrains.annotations.Nullable;

public class TerrariumProcessor
extends StructureProcessor {
    public static final Codec<TerrariumProcessor> CODEC = Codec.unit(TerrariumProcessor::new);

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos structPos, BlockPos blockPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, StructureTemplate template) {
        BlockState state = relativeBlockInfo.f_74676_();
        BlockPos worldPos = relativeBlockInfo.f_74675_();
        Holder biome = world.m_204166_(worldPos);
        RandomSource rand = settings.m_230326_(relativeBlockInfo.f_74675_());
        CompoundTag nbt = relativeBlockInfo.f_74677_();
        if (state.m_60713_(Blocks.f_50440_) && rand.m_188503_(5) == 0) {
            state = TerrariumProcessor.getLight((Holder<Biome>)biome).m_49966_();
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, state, nbt);
    }

    protected StructureProcessorType<TerrariumProcessor> m_6953_() {
        return (StructureProcessorType)PMStructures.TERRARIUM_PROCESSOR.get();
    }

    private static Block getLight(Holder<Biome> biome) {
        if (biome.m_203656_(PMTags.Biomes.SALT)) {
            return Misc.SALT_LAMP.get();
        }
        if (biome.m_203656_(BiomeTags.f_207603_)) {
            return Blocks.f_50386_;
        }
        return Blocks.f_50141_;
    }
}

