/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.surfacerules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.paradisemod.base.mixin.SurfaceRulesContextAccessor;
import net.paradisemod.base.mixin.SurfaceSystemAccessor;

public enum PMBandlands implements SurfaceRules.RuleSource
{
    CONCRETE(Blocks.f_50542_, Blocks.f_50543_, Blocks.f_50544_, Blocks.f_50545_, Blocks.f_50494_, Blocks.f_50495_, Blocks.f_50496_, Blocks.f_50497_, Blocks.f_50498_, Blocks.f_50499_, Blocks.f_50500_, Blocks.f_50501_, Blocks.f_50502_, Blocks.f_50503_, Blocks.f_50504_, Blocks.f_50505_),
    TERRACOTTA(Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_);

    public static final KeyDispatchDataCodec<PMBandlands> CODEC;
    private final List<BlockState> bandBlocks;

    private PMBandlands(Block ... bandBlocks) {
        this.bandBlocks = Arrays.stream(bandBlocks).map(Block::m_49966_).toList();
    }

    public KeyDispatchDataCodec<PMBandlands> m_213795_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        SurfaceSystem system = ((SurfaceRulesContextAccessor)context).surfaceSystem();
        NormalNoise clayBandsOffsetNoise = ((SurfaceSystemAccessor)system).getGetBandsNoise();
        return (x, y, z) -> {
            int ofs = (int)Math.round(clayBandsOffsetNoise.m_75380_((double)x, 0.0, (double)z) * 4.0);
            BlockState block = (this == CONCRETE ? Blocks.f_50543_ : Blocks.f_50352_).m_49966_();
            for (int i = 0; i < 16; ++i) {
                if ((y + ofs) % (i + 1) != 0) continue;
                block = this.bandBlocks.get(i);
            }
            return block;
        };
    }

    static {
        CODEC = KeyDispatchDataCodec.m_216236_((Codec)RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("group").stable().forGetter(bl -> bl.name().toLowerCase())).apply((Applicative)builder, builder.stable(s -> PMBandlands.valueOf(s.toUpperCase())))));
    }
}

