/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.warning.init;

import net.mcreator.warning.entity.FailedEntity;
import net.mcreator.warning.entity.FakeChickenEntity;
import net.mcreator.warning.entity.FakeCowEntity;
import net.mcreator.warning.entity.FakePigEntity;
import net.mcreator.warning.entity.FatalEntity;
import net.mcreator.warning.entity.LightEntity;
import net.mcreator.warning.entity.StalkerEntity;
import net.mcreator.warning.entity.WarningAttackEntity;
import net.mcreator.warning.entity.WarningCuriousEntity;
import net.mcreator.warning.entity.WarningEntity;
import net.mcreator.warning.entity.WarningScareEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class WarningModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"warning");
    public static final DeferredHolder<EntityType<?>, EntityType<FakePigEntity>> FAKE_PIG = WarningModEntities.register("fake_pig", EntityType.Builder.of(FakePigEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<WarningEntity>> WARNING = WarningModEntities.register("warning", EntityType.Builder.of(WarningEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(63).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<WarningAttackEntity>> WARNING_ATTACK = WarningModEntities.register("warning_attack", EntityType.Builder.of(WarningAttackEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(164).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FatalEntity>> FATAL = WarningModEntities.register("fatal", EntityType.Builder.of(FatalEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<WarningCuriousEntity>> WARNING_CURIOUS = WarningModEntities.register("warning_curious", EntityType.Builder.of(WarningCuriousEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FakeCowEntity>> FAKE_COW = WarningModEntities.register("fake_cow", EntityType.Builder.of(FakeCowEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<FailedEntity>> FAILED = WarningModEntities.register("failed", EntityType.Builder.of(FailedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<StalkerEntity>> STALKER = WarningModEntities.register("stalker", EntityType.Builder.of(StalkerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FakeChickenEntity>> FAKE_CHICKEN = WarningModEntities.register("fake_chicken", EntityType.Builder.of(FakeChickenEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<WarningScareEntity>> WARNING_SCARE = WarningModEntities.register("warning_scare", EntityType.Builder.of(WarningScareEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LightEntity>> LIGHT = WarningModEntities.register("light", EntityType.Builder.of(LightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        FakePigEntity.init(event);
        WarningEntity.init(event);
        WarningAttackEntity.init(event);
        FatalEntity.init(event);
        WarningCuriousEntity.init(event);
        FakeCowEntity.init(event);
        FailedEntity.init(event);
        StalkerEntity.init(event);
        FakeChickenEntity.init(event);
        WarningScareEntity.init(event);
        LightEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)FAKE_PIG.get(), FakePigEntity.createAttributes().build());
        event.put((EntityType)WARNING.get(), WarningEntity.createAttributes().build());
        event.put((EntityType)WARNING_ATTACK.get(), WarningAttackEntity.createAttributes().build());
        event.put((EntityType)FATAL.get(), FatalEntity.createAttributes().build());
        event.put((EntityType)WARNING_CURIOUS.get(), WarningCuriousEntity.createAttributes().build());
        event.put((EntityType)FAKE_COW.get(), FakeCowEntity.createAttributes().build());
        event.put((EntityType)FAILED.get(), FailedEntity.createAttributes().build());
        event.put((EntityType)STALKER.get(), StalkerEntity.createAttributes().build());
        event.put((EntityType)FAKE_CHICKEN.get(), FakeChickenEntity.createAttributes().build());
        event.put((EntityType)WARNING_SCARE.get(), WarningScareEntity.createAttributes().build());
        event.put((EntityType)LIGHT.get(), LightEntity.createAttributes().build());
    }
}

