/*
 * Decompiled with CFR 0.152.
 */
package com.msdoggirl.mekvamp;

import com.msdoggirl.mekvamp.Modules;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import java.util.concurrent.atomic.AtomicInteger;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AutofeederLogic {
    private static final int BLOOD_STEP = 100;

    public static void tick(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (VampirismAPI.factionRegistry().getFaction((Entity)player) != VReference.VAMPIRE_FACTION) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        long currentTime = player.m_9236_().m_46467_();
        long lastFeed = data.m_128454_("mekvamp_last_feed");
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        IModule module = IModuleHelper.INSTANCE.load(helmet, Modules.FEEDING_MODULE);
        if (module == null || !module.isEnabled()) {
            return;
        }
        IVampirePlayer vampire = (IVampirePlayer)VampirismAPI.getVampirePlayer((Player)player).orElse(null);
        if (vampire == null) {
            return;
        }
        IBloodStats stats = vampire.getBloodStats();
        if (stats == null) {
            return;
        }
        if (currentTime - lastFeed < 200L) {
            return;
        }
        int current = stats.getBloodLevel();
        int max = stats.getMaxBlood();
        int missing = max - current;
        if (missing <= 0) {
            return;
        }
        int request = Math.min(100, missing) * 100;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            int gained;
            if (stack.m_41619_() || (gained = AutofeederLogic.drainBloodFromItem(stack, request)) <= 0) continue;
            vampire.drinkBlood(gained / 100, 0.0f, (IDrinkBloodContext)new DrinkBloodContext(stack.m_41777_()));
            data.m_128356_("mekvamp_last_feed", currentTime);
            System.out.println("Player is missing " + request + " units of blood.");
            return;
        }
    }

    private static int drainBloodFromItem(ItemStack stack, int maxAmount) {
        if (stack.m_41619_()) {
            return 0;
        }
        AtomicInteger drainedAmount = new AtomicInteger(0);
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            FluidStack wanted = new FluidStack((Fluid)VReference.BLOOD.get(), maxAmount);
            FluidStack sim = handler.drain(wanted, IFluidHandler.FluidAction.SIMULATE);
            if (!sim.isEmpty() && sim.getAmount() > 0 && sim.getFluid().m_6212_((Fluid)VReference.BLOOD.get())) {
                FluidStack exec = handler.drain(wanted, IFluidHandler.FluidAction.EXECUTE);
                drainedAmount.set(exec.getAmount());
            }
        });
        return drainedAmount.get();
    }
}

