/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="darkdoppelganger", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_HEALTH;
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_ATTACK_DAMAGE;
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_MOVEMENT_SPEED;
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_KNOCKBACK_RESISTANCE;
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_ARMOR;
    public static final ModConfigSpec.DoubleValue DOPPELGANGER_FOLLOW_RANGE;
    public static final ModConfigSpec.BooleanValue DOPPELGANGER_HARD_MODE;
    public static final ModConfigSpec SPEC;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            // empty if block
        }
    }

    static {
        BUILDER.comment("Dark Doppelganger Configuration").push("dark_doppelganger");
        DOPPELGANGER_HEALTH = BUILDER.comment("Health of the Dark Doppelganger").defineInRange("health", 6000.0, 1.0, 100000.0);
        DOPPELGANGER_ATTACK_DAMAGE = BUILDER.comment("Attack Damage of the Dark Doppelganger").defineInRange("attack_damage", 20.0, 1.0, 100.0);
        DOPPELGANGER_MOVEMENT_SPEED = BUILDER.comment("Movement Speed of the Dark Doppelganger").defineInRange("movement_speed", 0.2, 0.1, 1.0);
        DOPPELGANGER_KNOCKBACK_RESISTANCE = BUILDER.comment("Knockback Resistance of the Dark Doppelganger").defineInRange("knockback_resistance", 0.6, 0.0, 1.0);
        DOPPELGANGER_ARMOR = BUILDER.comment("Armor of the Dark Doppelganger").defineInRange("armor", 20.0, 0.0, 100.0);
        DOPPELGANGER_FOLLOW_RANGE = BUILDER.comment("Follow Range of the Dark Doppelganger").defineInRange("follow_range", 64.0, 1.0, 128.0);
        DOPPELGANGER_HARD_MODE = BUILDER.comment("Hard mode of the Dark Doppelganger").define("hard_mode", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

