/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossMoveControl;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.NotIdioticNavigation;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Objects;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.entity.ai.PatchedWarlockAttackGoal;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.bandit.darkdoppelganger.registry.ItemRegistry;
import net.bandit.darkdoppelganger.registry.SoundRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DarkDoppelgangerEntity
extends AbstractSpellCastingMob
implements Enemy,
IAnimatedAttacker {
    @Nullable
    private Player summonerPlayer;
    private final ServerBossEvent bossEvent;
    private boolean secondPhaseTriggered = false;
    private boolean thirdPhaseTriggered = false;
    public boolean isClone = false;
    private boolean musicPlaying = false;
    private int minionSummonCooldown = 300;
    private int lifeDrainCooldown = 150;
    private int roarSoundCooldown = 800;
    private int laughSoundCooldown = 800;
    private static final int MAX_MINIONS = 5;
    private static int currentMinionCount = 0;
    private int laughCooldown = 800;
    private int age;
    private int musicTimer = 0;
    private static final int MUSIC_DURATION = 6160;
    private boolean hasFallenIntoVoid = false;
    private int teleportCooldown = 0;
    RawAnimation animationToPlay = null;
    private final RawAnimation ANIMATION_SPAWN = RawAnimation.begin().thenPlay("join_1");
    private final AnimationController<DarkDoppelgangerEntity> meleeController = new AnimationController((GeoAnimatable)this, "keeper_animations", 0, this::predicate);
    private final AnimationController<DarkDoppelgangerEntity> spawnController = new AnimationController((GeoAnimatable)this, "spawn_animations", 0, this::spawnPredicate);

    public DarkDoppelgangerEntity(EntityType<? extends AbstractSpellCastingMob> type, Level world) {
        super(type, world);
        this.setCustomName((Component)Component.literal((String)"Dark Doppelganger"));
        this.bossEvent = new ServerBossEvent((Component)Component.literal((String)"Dark Doppelganger"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float rotateTowards(float pFrom, float pTo, float pMaxDelta) {
                return super.rotateTowards(pFrom, pTo, pMaxDelta * 2.5f);
            }

            protected boolean resetXRotOnTick() {
                return DarkDoppelgangerEntity.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new FireBossMoveControl((Mob)this);
    }

    public FireBossMoveControl getMoveControl() {
        return (FireBossMoveControl)super.getMoveControl();
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new NotIdioticNavigation((Mob)this, pLevel);
    }

    public void setSummonerPlayer(Player summoner) {
        this.summonerPlayer = summoner;
        if (summoner != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemStack;
                if (slot == EquipmentSlot.OFFHAND || (itemStack = summoner.getItemBySlot(slot)).isEmpty()) continue;
                this.setItemSlot(slot, itemStack.copy());
            }
            this.setPersistenceRequired();
        }
        this.copyAttribute((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.NATURE_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.EVOCATION_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get());
        this.copyAttribute((Attribute)AttributeRegistry.SPELL_POWER.get());
        if (((Boolean)Config.DOPPELGANGER_HARD_MODE.get()).booleanValue()) {
            this.getAttribute(AttributeRegistry.HOLY_SPELL_POWER.getDelegate()).setBaseValue(1.3);
            this.getAttribute(AttributeRegistry.FIRE_MAGIC_RESIST.getDelegate()).setBaseValue(1.5);
            this.getAttribute(AttributeRegistry.BLOOD_MAGIC_RESIST.getDelegate()).setBaseValue(1.5);
            this.getAttribute(AttributeRegistry.ELDRITCH_MAGIC_RESIST.getDelegate()).setBaseValue((double)1.4f);
            this.getAttribute(AttributeRegistry.ICE_MAGIC_RESIST.getDelegate()).setBaseValue((double)1.6f);
            this.getAttribute(AttributeRegistry.LIGHTNING_MAGIC_RESIST.getDelegate()).setBaseValue((double)1.4f);
            this.getAttribute(AttributeRegistry.EVOCATION_MAGIC_RESIST.getDelegate()).setBaseValue((double)1.3f);
            this.getAttribute(AttributeRegistry.ENDER_MAGIC_RESIST.getDelegate()).setBaseValue((double)1.4f);
            this.getAttribute(AttributeRegistry.SPELL_RESIST.getDelegate()).setBaseValue(1.5);
        }
    }

    protected void registerGoals() {
        this.setFirstPhaseGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void setFirstPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), 3, 6, 100, 250, 1));
        this.goalSelector.addGoal(3, (Goal)new PatchedWarlockAttackGoal<DarkDoppelgangerEntity>(this, 1.25, 50, 75).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BURNING_DASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())));
        this.goalSelector.addGoal(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setSecondPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.FIREBALL_SPELL.get(), 3, 5, 100, 250, 1));
        this.goalSelector.addGoal(3, (Goal)new PatchedWarlockAttackGoal<DarkDoppelgangerEntity>(this, 1.25, 50, 75).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.MAGMA_BOMB_SPELL.get()), List.of((AbstractSpell)SpellRegistry.HEAT_SURGE_SPELL.get(), (AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FROST_STEP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), (AbstractSpell)SpellRegistry.THUNDERSTORM_SPELL.get())));
        this.goalSelector.addGoal(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setThirdPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 3, 5, 100, 250, 1));
        this.goalSelector.addGoal(3, (Goal)new PatchedWarlockAttackGoal<DarkDoppelgangerEntity>(this, 1.25, 50, 75).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get(), (AbstractSpell)SpellRegistry.ASCENSION_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get(), (AbstractSpell)SpellRegistry.ECHOING_STRIKES_SPELL.get())));
        this.goalSelector.addGoal(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setFinalPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.SCULK_TENTACLES_SPELL.get(), 3, 4, 100, 160, 1));
        this.goalSelector.addGoal(3, (Goal)new PatchedWarlockAttackGoal<DarkDoppelgangerEntity>(this, 1.4f, 30, 50).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.7f).setMeleeAttackInverval(10, 20).setMeleeMovespeedModifier(1.7f).setSpells(List.of((AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get(), (AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), (AbstractSpell)SpellRegistry.ABYSSAL_SHROUD_SPELL.get(), (AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), (AbstractSpell)SpellRegistry.SCULK_TENTACLES_SPELL.get()), List.of((AbstractSpell)SpellRegistry.ASCENSION_SPELL.get(), (AbstractSpell)SpellRegistry.ABYSSAL_SHROUD_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.ABYSSAL_SHROUD_SPELL.get(), (AbstractSpell)SpellRegistry.ECHOING_STRIKES_SPELL.get(), (AbstractSpell)SpellRegistry.ROOT_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get())));
        this.goalSelector.addGoal(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.setPersistenceRequired();
        if (this.isClone) {
            this.addTag("dark_doppelganger_clone");
        } else {
            this.addTag("dark_doppelganger_boss");
        }
        if (!this.level().isClientSide) {
            if (!this.isClone && !this.musicPlaying) {
                this.playBossMusic();
            }
            if (!this.isClone) {
                this.adjustAttributesFromConfig();
            }
        } else {
            this.spawnSummoningParticles();
        }
        PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.level());
        portal.setPos(this.position());
        portal.setYRot(this.getYRot());
        portal.yRotO = this.getYRot();
        this.level().addFreshEntity((Entity)portal);
    }

    private void copyAttribute(Attribute attribute) {
        AttributeInstance sourceAttribute = this.summonerPlayer.getAttribute((Holder)attribute);
        AttributeInstance targetAttribute = this.getAttribute((Holder)attribute);
        if (sourceAttribute != null && targetAttribute != null) {
            targetAttribute.setBaseValue(sourceAttribute.getBaseValue());
            for (AttributeModifier modifier : targetAttribute.getModifiers()) {
                targetAttribute.removeModifier(modifier);
            }
            for (AttributeModifier modifier : sourceAttribute.getModifiers()) {
                targetAttribute.addPermanentModifier(modifier);
            }
        }
    }

    private void adjustAttributesFromConfig() {
        if (Config.DOPPELGANGER_HEALTH != null) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.DOPPELGANGER_HEALTH.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ATTACK_DAMAGE != null) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.DOPPELGANGER_ATTACK_DAMAGE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_MOVEMENT_SPEED != null) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(((Double)Config.DOPPELGANGER_MOVEMENT_SPEED.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_KNOCKBACK_RESISTANCE != null) {
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.DOPPELGANGER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ARMOR != null) {
            this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.DOPPELGANGER_ARMOR.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_FOLLOW_RANGE != null) {
            this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(((Double)Config.DOPPELGANGER_FOLLOW_RANGE.get()).doubleValue());
        }
        this.setHealth(this.getMaxHealth());
    }

    private void applyAttributesFromConfig() {
        if (Config.DOPPELGANGER_HEALTH != null) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.DOPPELGANGER_HEALTH.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ATTACK_DAMAGE != null) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.DOPPELGANGER_ATTACK_DAMAGE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_MOVEMENT_SPEED != null) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(((Double)Config.DOPPELGANGER_MOVEMENT_SPEED.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_KNOCKBACK_RESISTANCE != null) {
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.DOPPELGANGER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ARMOR != null) {
            this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.DOPPELGANGER_ARMOR.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_FOLLOW_RANGE != null) {
            this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(((Double)Config.DOPPELGANGER_FOLLOW_RANGE.get()).doubleValue());
        }
        this.setHealth(this.getMaxHealth());
    }

    private void spawnSummoningParticles() {
        for (int i = 0; i < 20; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
            double yOffset = this.random.nextDouble();
            double zOffset = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void stopAllMusic() {
        if (!this.level().isClientSide && this.level().getServer() != null) {
            Objects.requireNonNull(this.level().getServer()).getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundStopSoundPacket(null, SoundSource.MUSIC)));
        }
    }

    private void stopMinecraftAmbientMusic() {
        if (!this.level().isClientSide && this.level().getServer() != null) {
            for (ServerPlayer player : Objects.requireNonNull(this.level().getServer()).getPlayerList().getPlayers()) {
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.game"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.creative"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.menu"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.day"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.night"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.hills"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.water"), SoundSource.MUSIC));
            }
        }
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (!this.isClone) {
            this.bossEvent.addPlayer(player);
        }
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        super.stopSeenByPlayer(player);
        if (!this.isClone) {
            this.bossEvent.removePlayer(player);
        }
    }

    public void tick() {
        Player summoner;
        super.tick();
        this.createOrJoinDoppelTeam();
        if (this.isClone || this.isDeadOrDying()) {
            return;
        }
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.musicPlaying) {
            this.stopMinecraftAmbientMusic();
            if (this.musicTimer > 0) {
                --this.musicTimer;
            } else {
                this.playBossMusic();
            }
        }
        if (!this.musicPlaying) {
            this.playBossMusic();
        }
        if (!this.isClone && this.laughCooldown > 0) {
            --this.laughCooldown;
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.4 && this.minionSummonCooldown <= 0) {
            this.summonIllusionClones();
            this.minionSummonCooldown = 1000;
        }
        if (!this.level().isClientSide && !this.hasFallenIntoVoid && this.level().dimension() == Level.END && this.getY() < -100.0 && (summoner = this.getSummonerPlayer()) != null && !summoner.isDeadOrDying()) {
            PortalJoinEntity exitPortal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.level());
            exitPortal.setPos(this.position());
            this.level().addFreshEntity((Entity)exitPortal);
            double targetX = summoner.getX();
            double targetY = summoner.getY() + 1.5;
            double targetZ = summoner.getZ();
            this.teleportTo(targetX, targetY, targetZ);
            this.setYRot(summoner.getYRot());
            this.level().playSound(null, summoner.blockPosition(), SoundEvents.PORTAL_TRAVEL, SoundSource.HOSTILE, 1.0f, 1.0f);
            PortalJoinEntity entrancePortal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.level());
            entrancePortal.setPos(targetX, targetY - 1.5, targetZ);
            this.level().addFreshEntity((Entity)entrancePortal);
            summoner.sendSystemMessage((Component)Component.literal((String)"The Dark Doppelganger has returned from the void...").withStyle(ChatFormatting.DARK_PURPLE));
            this.hasFallenIntoVoid = true;
            this.teleportCooldown = 100;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
            if (this.teleportCooldown == 0) {
                this.hasFallenIntoVoid = false;
            }
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.4 && this.minionSummonCooldown <= 0) {
            this.summonIllusionClones();
            this.minionSummonCooldown = 1000;
        }
        if (((Boolean)Config.DOPPELGANGER_HARD_MODE.get()).booleanValue()) {
            this.addEffect(new MobEffectInstance(MobEffectRegistry.OAKSKIN.getDelegate(), 10, 8, false, false, true));
            this.addEffect(new MobEffectInstance(MobEffectRegistry.CHARGED.getDelegate(), 10, 2, false, false, true));
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 10, 0, false, false));
        }
        if (((Boolean)Config.DOPPELGANGER_HARD_MODE.get()).booleanValue() && this.tickCount % 10 == 0) {
            this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(20.0, 10.0, 20.0)).forEach(target -> {
                if (target != this) {
                    if (target.hasEffect(MobEffects.DIG_SPEED)) {
                        target.removeEffect(MobEffects.DIG_SPEED);
                    }
                    if (target.hasEffect(MobEffectRegistry.ABYSSAL_SHROUD.getDelegate())) {
                        target.removeEffect(MobEffectRegistry.ABYSSAL_SHROUD.getDelegate());
                    }
                    if (target.hasEffect(MobEffectRegistry.EVASION.getDelegate())) {
                        target.removeEffect(MobEffectRegistry.EVASION.getDelegate());
                    }
                    if (target.hasEffect(MobEffectRegistry.HASTENED.getDelegate())) {
                        target.removeEffect(MobEffectRegistry.HASTENED.getDelegate());
                    }
                    if (target.hasEffect(MobEffectRegistry.ECHOING_STRIKES.getDelegate())) {
                        target.removeEffect(MobEffectRegistry.ECHOING_STRIKES.getDelegate());
                    }
                }
            });
        }
        if (this.thirdPhaseTriggered) {
            if (this.minionSummonCooldown-- <= 0) {
                this.summonMinions();
                this.minionSummonCooldown = 500;
            }
            if (this.lifeDrainCooldown-- <= 0) {
                this.lifeDrainAttack();
                this.lifeDrainCooldown = 150;
            }
        }
        if (this.roarSoundCooldown > 0) {
            --this.roarSoundCooldown;
        }
        if (this.laughSoundCooldown > 0) {
            --this.laughSoundCooldown;
        }
        ++this.age;
    }

    @Nullable
    public Player getSummonerPlayer() {
        return this.summonerPlayer;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    private void triggerSecondPhase() {
        this.secondPhaseTriggered = true;
        this.setHealth(this.getMaxHealth());
        for (ServerPlayer player : this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(50.0))) {
            player.sendSystemMessage((Component)Component.literal((String)"The Dark Doppelganger has entered its Second Phase!").withStyle(ChatFormatting.DARK_PURPLE));
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.BOSS_ROAR.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0));
        }
        this.level().explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            double angle = Math.toRadians(i * 36);
            double x = this.getX() + Math.cos(angle) * 10.0;
            double z = this.getZ() + Math.sin(angle) * 10.0;
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            if (lightning == null) continue;
            lightning.moveTo(x, this.getY(), z);
            this.level().addFreshEntity((Entity)lightning);
        }
    }

    private void triggerThirdPhase() {
        this.thirdPhaseTriggered = true;
        this.setHealth(this.getMaxHealth());
        this.bossEvent.setName((Component)Component.literal((String)"Dark Doppelganger - Final Phase"));
        for (ServerPlayer player : this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(50.0))) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.BOSS_ROAR.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.literal((String)"Final Form! Prepare yourself!").withStyle(ChatFormatting.RED), true);
        }
        for (ServerPlayer player : this.level().players()) {
            player.getCooldowns().addCooldown(Items.TOTEM_OF_UNDYING, 60);
        }
        this.level().explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, Level.ExplosionInteraction.TNT);
        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            double angle = Math.toRadians(i * 36);
            double x = this.getX() + Math.cos(angle) * 10.0;
            double z = this.getZ() + Math.sin(angle) * 10.0;
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            if (lightning == null) continue;
            lightning.moveTo(x, this.getY(), z);
            this.level().addFreshEntity((Entity)lightning);
        }
        this.minionSummonCooldown = 1050;
        this.lifeDrainCooldown = 200;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isDeadOrDying() || source == this.level().damageSources().fellOutOfWorld()) {
            return false;
        }
        if (this.isClone) {
            return super.hurt(source, amount);
        }
        float newHealth = this.getHealth() - amount;
        if (!this.secondPhaseTriggered && newHealth <= this.getMaxHealth() * 0.4f) {
            this.triggerSecondPhase();
            if (((Boolean)Config.DOPPELGANGER_HARD_MODE.get()).booleanValue()) {
                this.setThirdPhaseGoals();
            } else {
                this.setSecondPhaseGoals();
            }
            return false;
        }
        if (!this.thirdPhaseTriggered && newHealth <= this.getMaxHealth() * 0.2f) {
            this.triggerThirdPhase();
            if (((Boolean)Config.DOPPELGANGER_HARD_MODE.get()).booleanValue()) {
                this.setFinalPhaseGoals();
            } else {
                this.setThirdPhaseGoals();
            }
            return false;
        }
        Entity attacker = source.getEntity();
        if (attacker instanceof LivingEntity && attacker != this) {
            this.setTarget((LivingEntity)attacker);
        }
        return super.hurt(source, amount);
    }

    private void summonIllusionClones() {
        if (this.minionSummonCooldown > 0 || currentMinionCount >= 5) {
            return;
        }
        for (int i = 0; i < 3 && currentMinionCount < 5; ++i) {
            DarkDoppelgangerEntity clone = (DarkDoppelgangerEntity)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()).create(this.level());
            if (clone == null) continue;
            clone.setPos(this.getX() + (double)this.random.nextInt(5) - 2.0, this.getY(), this.getZ() + (double)this.random.nextInt(5) - 2.0);
            clone.setHealth(10.0f);
            clone.isClone = true;
            PlayerTeam team = this.getTeam();
            if (team instanceof PlayerTeam) {
                PlayerTeam playerTeam = team;
                this.level().getScoreboard().addPlayerToTeam(clone.getScoreboardName(), playerTeam);
            }
            clone.addTag("dark_doppelganger_clone");
            clone.setCustomName((Component)Component.literal((String)"Doppelganger Clone").withStyle(ChatFormatting.GRAY));
            clone.applyAttributesFromConfig();
            this.level().addFreshEntity((Entity)clone);
            this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, clone.getX(), clone.getY(), clone.getZ(), 0.0, 1.0, 0.0);
            ++currentMinionCount;
        }
        this.minionSummonCooldown = 500;
    }

    private void summonMinions() {
        if (this.isClone || this.minionSummonCooldown > 0 || currentMinionCount >= 5) {
            return;
        }
        for (int i = 0; i < 2 && currentMinionCount < 5; ++i) {
            DarkDoppelgangerEntity minion = (DarkDoppelgangerEntity)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()).create(this.level());
            if (minion == null) continue;
            minion.setPos(this.getX() + (double)this.random.nextInt(5) - 2.0, this.getY(), this.getZ() + (double)this.random.nextInt(5) - 2.0);
            minion.setHealth(minion.getMaxHealth() * 0.3f);
            minion.isClone = true;
            minion.addTag("dark_doppelganger_clone");
            PlayerTeam team = this.getTeam();
            if (team instanceof PlayerTeam) {
                PlayerTeam playerTeam = team;
                this.level().getScoreboard().addPlayerToTeam(minion.getScoreboardName(), playerTeam);
            }
            minion.setCustomName((Component)Component.literal((String)"Doppelganger Minion").withStyle(ChatFormatting.DARK_GRAY));
            this.level().addFreshEntity((Entity)minion);
            minion.applyAttributesFromConfig();
            ++currentMinionCount;
        }
        this.minionSummonCooldown = 500;
    }

    private void lifeDrainAttack() {
        this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(8.0)).forEach(player -> {
            player.hurt(this.level().damageSources().magic(), 4.0f);
            this.heal(4.0f);
        });
        if (this.laughCooldown <= 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.BOSS_LAUGH.get(), SoundSource.HOSTILE, 0.0f, 1.0f);
            this.laughCooldown = 400;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die(@NotNull DamageSource cause) {
        if (this.isClone) {
            Class<DarkDoppelgangerEntity> clazz = DarkDoppelgangerEntity.class;
            synchronized (DarkDoppelgangerEntity.class) {
                currentMinionCount = Math.max(0, currentMinionCount - 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                super.die(cause);
                return;
            }
        }
        if (!this.thirdPhaseTriggered) {
            this.setHealth(1.0f);
            return;
        }
        if (this.musicPlaying) {
            this.stopBossMusic();
            this.musicPlaying = false;
            this.musicTimer = 0;
        }
        if (!this.level().isClientSide) {
            ServerPlayer serverPlayer;
            Entity entity = cause.getEntity();
            if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).getServer() != null) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"You have slain the Dark Doppelganger!"));
            }
            this.spawnAtLocation((ItemLike)ItemRegistry.DOPPELGANGER_RING.get());
            this.spawnAtLocation((ItemLike)Items.NETHER_STAR);
            this.spawnAtLocation((ItemLike)Items.ECHO_SHARD, 3);
            this.spawnAtLocation((ItemLike)Items.DIAMOND_BLOCK, 3);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), 2500));
        }
        if (this.level().getServer() != null) {
            this.level().getServer().getPlayerList().getPlayers().forEach(player -> {
                if (player.connection != null) {
                    player.connection.send((Packet)new ClientboundStopSoundPacket(((SoundEvent)SoundRegistry.BOSS_FIGHT_MUSIC.get()).getLocation(), SoundSource.MUSIC));
                }
            });
        }
        if (this.bossEvent != null) {
            this.bossEvent.removeAllPlayers();
        }
        super.die(cause);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6000.0).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.ARMOR, 20.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PlayState predicate(AnimationState<DarkDoppelgangerEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age > 45 && this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.spawnController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState spawnPredicate(AnimationState<DarkDoppelgangerEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age < 45) {
            controller.setAnimation(this.ANIMATION_SPAWN);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.meleeController);
        controllerRegistrar.add(this.spawnController);
        super.registerControllers(controllerRegistrar);
    }

    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationController.State.STOPPED || this.spawnController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    private void playBossMusic() {
        if (!(this.level().isClientSide || this.musicPlaying || this.isDeadOrDying())) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.BOSS_FIGHT_MUSIC.get(), SoundSource.MUSIC, 1.0f, 1.0f);
            this.musicPlaying = true;
            this.musicTimer = 6160;
        }
    }

    private void stopBossMusic() {
        if (!this.level().isClientSide && this.level().getServer() != null) {
            Objects.requireNonNull(this.level().getServer()).getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundStopSoundPacket(((SoundEvent)SoundRegistry.BOSS_FIGHT_MUSIC.get()).getLocation(), SoundSource.MUSIC)));
        }
    }

    private void createOrJoinDoppelTeam() {
        String teamName;
        if (this.level().isClientSide || this.getTeam() != null) {
            return;
        }
        Scoreboard scoreboard = this.level().getScoreboard();
        PlayerTeam team = scoreboard.getPlayerTeam(teamName = "dark_doppelganger_team");
        if (team == null) {
            team = scoreboard.addPlayerTeam(teamName);
            team.setAllowFriendlyFire(false);
            team.setSeeFriendlyInvisibles(true);
        }
        scoreboard.addPlayerToTeam(this.getScoreboardName(), team);
    }
}

