/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.event;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.bandit.darkdoppelganger.registry.SoundRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonDoppelganger {
    public static int summonDoppelganger(CommandSourceStack source) {
        try {
            ServerLevel serverWorld = source.getLevel();
            Player nearestPlayer = serverWorld.getNearestPlayer(TargetingConditions.forNonCombat().range(50.0), source.getPosition().x(), source.getPosition().y(), source.getPosition().z());
            if (nearestPlayer == null) {
                source.sendFailure((Component)Component.literal((String)"No players nearby to copy."));
                return 0;
            }
            source.sendSuccess(() -> Component.literal((String)("Dark Doppelganger will spawn in 5 seconds, copying " + nearestPlayer.getName().getString() + "!")), true);
            serverWorld.getServer().submitAsync(() -> {
                try {
                    Thread.sleep(5000L);
                    serverWorld.getServer().execute(() -> {
                        if (nearestPlayer.isAlive() && nearestPlayer.level() == serverWorld) {
                            SummonDoppelganger.summonDoppelganger(serverWorld, nearestPlayer);
                        } else {
                            source.sendFailure((Component)Component.literal((String)"Target player is no longer valid."));
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"An error occurred while executing the command."));
            return 0;
        }
    }

    private static void summonDoppelganger(ServerLevel serverWorld, Player player) {
        try {
            if (player == null || !player.isAlive()) {
                return;
            }
            Vec3 lookVector = player.getLookAngle();
            Vec3 initialSpawnPosition = player.position().add(lookVector.scale(4.0));
            BlockPos groundPos = new BlockPos((int)initialSpawnPosition.x, (int)initialSpawnPosition.y, (int)initialSpawnPosition.z);
            while (serverWorld.isEmptyBlock(groundPos.below()) && groundPos.getY() > serverWorld.getMinBuildHeight()) {
                groundPos = groundPos.below();
            }
            BlockPos spawnPosition = groundPos.above();
            DarkDoppelgangerEntity entity = new DarkDoppelgangerEntity((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), (Level)serverWorld);
            entity.setPos((double)spawnPosition.getX() + 0.5, spawnPosition.getY(), (double)spawnPosition.getZ() + 0.5);
            entity.setYRot(-player.getYRot());
            entity.setSummonerPlayer(player);
            entity.addTag("dark_doppelganger_boss");
            entity.setCustomName((Component)Component.literal((String)player.getName().getString()));
            entity.setCustomNameVisible(true);
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            serverWorld.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.BOSS_LAUGH.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            serverWorld.addFreshEntity((Entity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

