/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.items;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import java.util.List;
import net.bandit.darkdoppelganger.curios.CurioBaseItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class DoppelgangerRingItem
extends CurioBaseItem {
    private static final int BASE_COOLDOWN = 100;
    private static final double HEALTH_BONUS = 20.0;
    private static final double COOLDOWN_REDUCTION_PERCENT = 0.2;

    public DoppelgangerRingItem(Item.Properties properties) {
        super(properties);
        this.withAttributes(new AttributeContainer(Attributes.MAX_HEALTH, 20.0, AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.COOLDOWN_REDUCTION, 0.2, AttributeModifier.Operation.ADD_VALUE));
    }

    public boolean tryProcCooldown(Player player) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        player.getCooldowns().addCooldown((Item)this, 100);
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player && (player = (Player)entity).getHealth() < player.getMaxHealth() && player.tickCount % 20 == 0) {
            player.heal(0.5f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.passive_ability", (Object[])new Object[]{5}).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.health_bonus", (Object[])new Object[]{20.0}).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.cooldown_reduction", (Object[])new Object[]{"20%"}).withStyle(ChatFormatting.AQUA));
    }
}

