/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.items;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import java.util.UUID;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.registry.ComponentRegistry;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.bandit.darkdoppelganger.registry.SoundRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ShadowOrbItem
extends Item {
    public ShadowOrbItem(Item.Properties properties) {
        super(properties);
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        stack.set((DataComponentType)ComponentRegistry.THROWER_UUID.get(), (Object)player.getUUID());
        super.onCraftedBy(stack, level, player);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide && level instanceof ServerLevel) {
            Player nearest;
            ServerLevel serverLevel = (ServerLevel)level;
            UUID throwerId = (UUID)stack.get((DataComponentType)ComponentRegistry.THROWER_UUID.get());
            if (throwerId == null && (nearest = level.getNearestPlayer((Entity)entity, 5.0)) != null) {
                stack.set((DataComponentType)ComponentRegistry.THROWER_UUID.get(), (Object)nearest.getUUID());
                throwerId = nearest.getUUID();
            }
            if (level.dimension() == Level.END && entity.getY() < 0.0) {
                Player player;
                if (throwerId != null && (player = serverLevel.getPlayerByUUID(throwerId)) != null) {
                    level.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.BOSS_LAUGH.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
                    serverLevel.getServer().execute(() -> {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.summonDoppelganger(serverLevel, player);
                    });
                }
                entity.discard();
            }
        }
        return false;
    }

    private void summonDoppelganger(ServerLevel level, Player player) {
        Vec3 forward = player.getLookAngle().normalize().scale(3.0);
        Vec3 spawnPos = player.position().add(forward).add(0.0, 1.0, 0.0);
        BlockPos groundCheck = BlockPos.containing((double)spawnPos.x, (double)(spawnPos.y - 1.0), (double)spawnPos.z);
        BlockState stateBelow = level.getBlockState(groundCheck);
        if (stateBelow.isAir() || !stateBelow.isSolidRender((BlockGetter)level, groundCheck)) {
            spawnPos = player.position();
        }
        DarkDoppelgangerEntity boss = new DarkDoppelgangerEntity((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), (Level)level);
        boss.setPos(spawnPos);
        boss.setCustomName((Component)Component.literal((String)player.getName().getString()));
        boss.setCustomNameVisible(true);
        boss.setSummonerPlayer(player);
        boss.addTag("dark_doppelganger_boss");
        boss.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((Holder)ItemRegistry.PYRIUM_STAFF));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack armorToEquip = switch (slot) {
                case EquipmentSlot.HEAD -> new ItemStack((Holder)ItemRegistry.SHADOWWALKER_HELMET);
                case EquipmentSlot.CHEST -> new ItemStack((Holder)ItemRegistry.SHADOWWALKER_CHESTPLATE);
                case EquipmentSlot.LEGS -> new ItemStack((Holder)ItemRegistry.SHADOWWALKER_LEGGINGS);
                case EquipmentSlot.FEET -> new ItemStack((Holder)ItemRegistry.SHADOWWALKER_BOOTS);
                default -> ItemStack.EMPTY;
            };
            boss.setItemSlot(slot, armorToEquip);
        }
        level.addFreshEntity((Entity)boss);
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, boss.getX(), boss.getY(), boss.getZ(), 30, 0.5, 1.0, 0.5, 0.05);
        level.playSound(null, boss.blockPosition(), SoundEvents.ENDERMAN_STARE, SoundSource.HOSTILE, 1.0f, 0.5f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Throw into the void...").withStyle(ChatFormatting.DARK_PURPLE));
        tooltipComponents.add((Component)Component.literal((String)"Only in The End. Something awaits.").withStyle(ChatFormatting.GRAY));
    }
}

