/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import java.util.List;
import java.util.Optional;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.entity.PortalLeaveEntity;
import net.bandit.darkdoppelganger.registry.AnimationsRegistry;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DoppelPortalSpell
extends AbstractSpell {
    private boolean portalSpawned = false;
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"doppel_portal");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(5.0).build();

    public DoppelPortalSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 3;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public int getCastTime(int spellLevel) {
        return this.castTime + 5 * spellLevel;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.ENDERMAN_TELEPORT);
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationsRegistry.PLAYER_JOIN;
    }

    public AnimationHolder getCastStartAnimation() {
        return AnimationsRegistry.PLAYER_LEAVE;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!this.portalSpawned) {
            PortalLeaveEntity portal = new PortalLeaveEntity((EntityType)EntityRegistry.PORTAL_LEAVE_ENTITY.get(), level);
            this.portalSpawned = true;
            portal.setYRot(entity.getYRot());
            portal.yRotO = entity.getYRot();
            portal.setPos(entity.position());
            level.addFreshEntity((Entity)portal);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        if (playerMagicData != null) {
            Vec3 potentialTarget;
            TeleportSpell.TeleportData teleportData = (TeleportSpell.TeleportData)playerMagicData.getAdditionalCastData();
            Vec3 dest = null;
            if (teleportData != null && (potentialTarget = teleportData.getTeleportTargetPosition()) != null) {
                dest = potentialTarget;
            }
            if (dest == null) {
                dest = DoppelPortalSpell.findTeleportLocation(level, entity, this.getDistance(spellLevel, entity));
            }
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            entity.teleportTo(dest.x, dest.y, dest.z);
            entity.resetFallDistance();
            playerMagicData.resetAdditionalCastData();
            entity.playSound(this.getCastFinishSound().get(), 2.0f, 1.0f);
            PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), level);
            portal.setYRot(entity.getYRot());
            portal.yRotO = entity.getYRot();
            portal.setPos(dest);
            level.addFreshEntity((Entity)portal);
        }
        this.portalSpawned = false;
        super.onServerCastComplete(level, spellLevel, entity, playerMagicData, cancelled);
    }

    public static Vec3 findTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        boolean los;
        BlockHitResult blockHitResult = Utils.getTargetBlock((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        BlockPos pos = blockHitResult.getBlockPos();
        Vec3 bbOffset = entity.getForward().normalize().multiply((double)(entity.getBbWidth() / 3.0f), 0.0, (double)(entity.getBbHeight() / 3.0f));
        Vec3 bbImpact = blockHitResult.getLocation().subtract(bbOffset);
        int ledgeY = (int)level.clip((ClipContext)new ClipContext((Vec3)Vec3.atBottomCenterOf((Vec3i)pos).add((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.atBottomCenterOf((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (Entity)((Entity)null))).getLocation().y;
        boolean isAir = level.getBlockState(new BlockPos(new Vec3i(pos.getX(), ledgeY, pos.getZ()))).isAir();
        boolean bl = los = level.clip(new ClipContext(bbImpact, bbImpact.add(0.0, (double)(ledgeY - pos.getY()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).getType() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - pos.getY()) <= 3) {
            Vec3 correctedPos = new Vec3((double)pos.getX(), (double)ledgeY, (double)pos.getZ());
            return correctedPos.add(0.5, 0.076, 0.5);
        }
        return level.clip(new ClipContext(bbImpact, bbImpact.add(0.0, (double)(-entity.getBbHeight()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).getLocation().add(0.0, 0.076, 0.0);
    }

    private float getDistance(int spellLevel, LivingEntity sourceEntity) {
        return (float)(Utils.softCapFormula((double)this.getEntityPowerMultiplier(sourceEntity)) * (double)this.getSpellPower(spellLevel + 8, null));
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation((double)this.getDistance(spellLevel, caster), (int)1)}));
    }
}

