/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.command.ModCommands;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerMinionEntity;
import net.bandit.darkdoppelganger.entity.renderer.DarkDoppelgangerMinionRenderer;
import net.bandit.darkdoppelganger.entity.renderer.DarkDoppelgangerRenderer;
import net.bandit.darkdoppelganger.entity.renderer.PortalJoinRenderer;
import net.bandit.darkdoppelganger.entity.renderer.PortalLeaveRenderer;
import net.bandit.darkdoppelganger.registry.ComponentRegistry;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.bandit.darkdoppelganger.registry.ItemRegistry;
import net.bandit.darkdoppelganger.registry.SoundRegistry;
import net.bandit.darkdoppelganger.registry.SpellRegistry;
import net.bandit.darkdoppelganger.registry.TabRegistry;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.slf4j.Logger;

@Mod(value="darkdoppelganger")
public class DarkDoppelgangerMod {
    public static final String MOD_ID = "darkdoppelganger";
    private static final Logger LOGGER = LogUtils.getLogger();

    public DarkDoppelgangerMod(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onEntityAttributeCreation);
        SoundRegistry.register(modEventBus);
        EntityRegistry.register(modEventBus);
        SpellRegistry.register(modEventBus);
        ItemRegistry.register(modEventBus);
        TabRegistry.register(modEventBus);
        ComponentRegistry.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup for Dark Doppelganger Mod");
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityRegistry.DARK_DOPPELGANGER.get(), DarkDoppelgangerEntity.createAttributes().build());
        event.put((EntityType)EntityRegistry.DARK_DOPPELGANGER_MINION.get(), DarkDoppelgangerMinionEntity.createAttributes().build());
    }

    @EventBusSubscriber(modid="darkdoppelganger", bus=EventBusSubscriber.Bus.GAME)
    public static class CommandRegistration {
        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @EventBusSubscriber(modid="darkdoppelganger", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register((EntityType)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), DarkDoppelgangerRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)EntityRegistry.DARK_DOPPELGANGER_MINION.get()), DarkDoppelgangerMinionRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get()), PortalJoinRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)EntityRegistry.PORTAL_LEAVE_ENTITY.get()), PortalLeaveRenderer::new);
            LOGGER.info("Client setup for Dark Doppelganger Mod");
        }
    }
}

