/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;

public class DarkDoppelBossBar {
    private static final ResourceLocation BASE = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"textures/gui/doppel_bossbar.png");
    private static final ResourceLocation FILL = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"textures/gui/doppel_fill.png");
    private static final int FRAME_WIDTH = 250;
    private static final int FRAME_HEIGHT = 50;
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final int BAR_OFFSET_X = 34;
    private static final int BAR_OFFSET_Y = 12;

    public static void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent boss = event.getBossEvent();
        if (!boss.getName().getString().startsWith("Dark Doppelganger")) {
            return;
        }
        event.setCanceled(true);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int y = event.getY();
        int x = (screenWidth - 250) / 2;
        float progress = boss.getProgress();
        int filledWidth = (int)(progress * 182.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (filledWidth > 0) {
            guiGraphics.blit(FILL, x + 34, y + 12, 0.0f, 0.0f, filledWidth, 5, 256, 256);
        }
        guiGraphics.blit(BASE, x, y, 0.0f, 0.0f, 250, 50, 250, 50);
        Component name = boss.getName();
        int textX = screenWidth / 2 - Minecraft.getInstance().font.width((FormattedText)name) / 2;
        guiGraphics.drawString(Minecraft.getInstance().font, name, textX, y - 8, ChatFormatting.DARK_PURPLE.getColor().intValue());
        event.setIncrement(50);
    }
}

