/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossMoveControl;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.NotIdioticNavigation;
import java.util.List;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.entity.ai.PatchedWarlockAttackGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DarkDoppelgangerMinionEntity
extends AbstractSpellCastingMob
implements Enemy,
IAnimatedAttacker {
    private int age;
    @Nullable
    private UUID summonerUUID;
    private RawAnimation animationToPlay = null;
    private final RawAnimation ANIMATION_SPAWN = RawAnimation.begin().thenPlay("join_1");
    private final AnimationController<DarkDoppelgangerMinionEntity> meleeController = new AnimationController((GeoAnimatable)this, "keeper_animations", 0, this::predicate);
    private final AnimationController<DarkDoppelgangerMinionEntity> spawnController = new AnimationController((GeoAnimatable)this, "spawn_animations", 0, this::spawnPredicate);

    public DarkDoppelgangerMinionEntity(EntityType<? extends AbstractSpellCastingMob> type, Level world) {
        super(type, world);
        this.setCustomName((Component)Component.literal((String)"Dark Doppelganger Minion"));
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
    }

    @Nullable
    public ServerPlayer getSummonerPlayer() {
        Level level;
        if (this.summonerUUID == null || !((level = this.level()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return serverLevel.getServer().getPlayerList().getPlayer(this.summonerUUID);
    }

    public void setSummonerUUID(UUID uuid) {
        this.summonerUUID = uuid;
    }

    public boolean isPersistenceRequired() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ARMOR, 4.0);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.MINION_HEALTH.get()).doubleValue());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.MINION_ATTACK_DAMAGE.get()).doubleValue());
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(((Double)Config.MINION_MOVEMENT_SPEED.get()).doubleValue());
            this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.MINION_ARMOR.get()).doubleValue());
            this.setHealth(this.getMaxHealth());
        }
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PlayState predicate(AnimationState<DarkDoppelgangerMinionEntity> event) {
        AnimationController controller = event.getController();
        if (this.age > 45 && this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.spawnController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState spawnPredicate(AnimationState<DarkDoppelgangerMinionEntity> event) {
        AnimationController controller = event.getController();
        if (this.age < 45) {
            controller.setAnimation(this.ANIMATION_SPAWN);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.meleeController);
        controllerRegistrar.add(this.spawnController);
        super.registerControllers(controllerRegistrar);
    }

    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationController.State.STOPPED || this.spawnController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    protected MoveControl createMoveControl() {
        return new FireBossMoveControl((Mob)this);
    }

    public FireBossMoveControl getMoveControl() {
        return (FireBossMoveControl)super.getMoveControl();
    }

    protected PathNavigation createNavigation(Level level) {
        return new NotIdioticNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        ++this.age;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.summonerUUID != null) {
            tag.putUUID("SummonerUUID", this.summonerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("SummonerUUID")) {
            this.summonerUUID = tag.getUUID("SummonerUUID");
        }
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    protected void registerGoals() {
        this.setFirstPhaseGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void setFirstPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), 3, 6, 100, 250, 1));
        this.goalSelector.addGoal(3, (Goal)new PatchedWarlockAttackGoal<DarkDoppelgangerMinionEntity>(this, 1.25, 50, 75).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BURNING_DASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())));
        this.goalSelector.addGoal(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }
}

