/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.bandit.darkdoppelganger.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class EnderField
extends AoeEntity {
    private DamageSource damageSource;

    public EnderField(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public EnderField(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.ENDER_FIELD.get()), level);
    }

    public void applyEffect(LivingEntity target) {
        if (this.damageSource == null) {
            this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)target, (ResourceKey)ISSDamageTypes.FIRE_FIELD), (Entity)this, this.getOwner());
        }
        DamageSources.ignoreNextKnockback((LivingEntity)target);
        target.hurt(this.damageSource, this.getDamage());
    }

    public float getParticleCount() {
        return 1.5f * this.getRadius();
    }

    protected float particleYOffset() {
        return 0.25f;
    }

    protected float getParticleSpeedModifier() {
        return 1.4f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.of(ParticleHelper.UNSTABLE_ENDER);
    }
}

