/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity.ai;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackKeyframe;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.InvokeDaggerKeyframe;
import io.redspace.ironsspellbooks.particle.FlameStrikeParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.ai.EnderBossAttackKeyframe;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderBossAttackGoal
extends GenericAnimatedWarlockAttackGoal<DarkDoppelgangerEntity> {
    private static final AttributeModifier MODIFIER_ENDERIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"enderifier"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    int abilityCooldown;

    public EnderBossAttackGoal(DarkDoppelgangerEntity abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval) {
        super((PathfinderMob)abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval);
    }

    protected void doMovement(double distanceSquared) {
        double speed = (double)(this.spellCastingMob.isCasting() ? 0.75f : 1.0f) * this.movementSpeed();
        ((DarkDoppelgangerEntity)this.mob).lookAt((Entity)this.target, 30.0f, 30.0f);
        float meleeRange = this.meleeRange();
        float strafeMultiplier = this.getStrafeMultiplier();
        if (distanceSquared < (double)this.spellcastingRangeSqr && this.seeTime >= 5) {
            ((DarkDoppelgangerEntity)this.mob).getNavigation().stop();
            if (++this.strafeTime > 40 && ((DarkDoppelgangerEntity)this.mob).getRandom().nextDouble() < 0.08) {
                this.strafingClockwise = !this.strafingClockwise;
                this.strafeTime = 0;
            }
            float strafeForward = this.meleeMoveSpeedModifier;
            strafeForward = distanceSquared > (double)(meleeRange * meleeRange * 3.0f * 3.0f) ? (strafeForward *= 2.0f) : (distanceSquared > (double)(meleeRange * meleeRange) * 0.75 * 0.75 ? (strafeForward *= 1.3f) : (strafeForward *= -1.15f));
            int strafeDir = this.strafingClockwise ? 1 : -1;
            ((DarkDoppelgangerEntity)this.mob).getMoveControl().strafe(strafeForward * strafeMultiplier, (float)speed * (float)strafeDir * strafeMultiplier);
        } else if (((DarkDoppelgangerEntity)this.mob).tickCount % 5 == 0) {
            ((DarkDoppelgangerEntity)this.mob).setXxa(0.0f);
            ((DarkDoppelgangerEntity)this.mob).getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    protected void onHitFrame(AttackKeyframe attackKeyframe, float meleeRange) {
        if (attackKeyframe instanceof InvokeDaggerKeyframe) {
            ((DarkDoppelgangerEntity)this.mob).playSound((SoundEvent)SoundRegistry.ENDER_CAST.get(), 3.0f, 1.0f);
        } else {
            super.onHitFrame(attackKeyframe, meleeRange);
            if (attackKeyframe instanceof EnderBossAttackKeyframe) {
                EnderBossAttackKeyframe enderKeyframe = (EnderBossAttackKeyframe)attackKeyframe;
                boolean mirrored = enderKeyframe.swingData.mirrored();
                boolean vertical = enderKeyframe.swingData.vertical();
                Vec3 forward = ((DarkDoppelgangerEntity)this.mob).getForward();
                float reach = 2.0f * ((DarkDoppelgangerEntity)this.mob).getScale();
                Vec3 hitLocation = ((DarkDoppelgangerEntity)this.mob).getBoundingBox().getCenter().add(((DarkDoppelgangerEntity)this.mob).getForward().multiply((double)reach, 0.5, (double)reach));
                MagicManager.spawnParticles((Level)((DarkDoppelgangerEntity)this.mob).level(), (ParticleOptions)new FlameStrikeParticleOptions((float)forward.x, (float)forward.y, (float)forward.z, mirrored, vertical, ((DarkDoppelgangerEntity)this.mob).getScale()), (double)hitLocation.x, (double)hitLocation.y, (double)hitLocation.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            }
        }
    }

    public void stop() {
        super.stop();
        ((DarkDoppelgangerEntity)this.mob).getAttribute((Holder)AttributeRegistry.CAST_TIME_REDUCTION).removeModifier(MODIFIER_ENDERIFIER);
    }

    protected void handleAttackLogic(double distanceSquared) {
        int shortcut;
        float meleeRange = this.meleeRange();
        if (this.abilityCooldown > 0) {
            if (this.abilityCooldown == 180) {
                ((DarkDoppelgangerEntity)this.mob).getAttribute((Holder)AttributeRegistry.CAST_TIME_REDUCTION).removeModifier(MODIFIER_ENDERIFIER);
            }
            --this.abilityCooldown;
        } else if (!((DarkDoppelgangerEntity)this.mob).onGround() && distanceSquared > (double)(meleeRange * meleeRange * 2.0f * 2.0f) && !this.isActing()) {
            ((DarkDoppelgangerEntity)this.mob).getAttribute((Holder)AttributeRegistry.CAST_TIME_REDUCTION).addOrUpdateTransientModifier(MODIFIER_ENDERIFIER);
            ((DarkDoppelgangerEntity)this.mob).initiateCastSpell((AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), 3);
            this.abilityCooldown = 200;
            return;
        }
        if (this.meleeAnimTimer > 0 && this.currentAttack != null && this.meleeAnimTimer < (shortcut = 5) && this.currentAttack.attacks.keySet().intStream().noneMatch(i -> i > this.currentAttack.lengthInTicks - shortcut)) {
            this.meleeAnimTimer = 0;
        }
        super.handleAttackLogic(distanceSquared);
    }

    protected void doMeleeAction() {
        super.doMeleeAction();
        if (this.currentAttack != null) {
            float r = this.meleeRange();
            if (((DarkDoppelgangerEntity)this.mob).distanceToSqr((Entity)this.target) > 0.5625 * (double)r * (double)r) {
                int i = this.currentAttack.attacks.keySet().intStream().sorted().findFirst().orElse(0);
                ((DarkDoppelgangerEntity)this.mob).getMoveControl().triggerCustomMovement(i + 5, f -> new Vec3(0.0, 0.0, 0.5 * (double)(1.0f + this.currentAttack.rangeMultiplier)));
            }
        }
    }

    protected double movementSpeed() {
        return this.meleeMoveSpeedModifier;
    }

    public void playSwingSound() {
        ((DarkDoppelgangerEntity)this.mob).playSound((SoundEvent)SoundRegistry.HELLRAZOR_SWING.get(), 1.0f, (float)Mth.randomBetweenInclusive((RandomSource)((DarkDoppelgangerEntity)this.mob).getRandom(), (int)9, (int)11) * 0.1f);
    }
}

