/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity.ai;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.AnimatedActionGoal;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.EnderDaggerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class EnderDaggerSwarmAbilityGoal
extends AnimatedActionGoal<DarkDoppelgangerEntity> {
    public static final int ANIM_DURATION = 25;
    public static final int ACTION_TIMESTAMP = 17;

    public EnderDaggerSwarmAbilityGoal(DarkDoppelgangerEntity mob) {
        super((Mob)mob);
    }

    protected boolean canStartAction() {
        return ((DarkDoppelgangerEntity)this.mob).getTarget() != null && !((DarkDoppelgangerEntity)this.mob).isClone;
    }

    protected int getActionTimestamp() {
        return 17;
    }

    protected int getActionDuration() {
        return 25;
    }

    protected int getCooldown() {
        return Utils.random.nextIntBetweenInclusive(40, 80);
    }

    protected String getAnimationId() {
        return "summon_fiery_daggers";
    }

    protected void doAction() {
        LivingEntity target = ((DarkDoppelgangerEntity)this.mob).getTarget();
        if (target != null) {
            ((DarkDoppelgangerEntity)this.mob).playSound((SoundEvent)SoundRegistry.ENDER_CAST.get(), 2.0f, (float)Utils.random.nextIntBetweenInclusive(80, 110) * 0.01f);
            Vec3 pos = ((DarkDoppelgangerEntity)this.mob).position();
            int count = 7;
            int delay = Utils.random.nextIntBetweenInclusive(30, 70);
            float yAngle = -Utils.getAngle((double)target.getX(), (double)target.getZ(), (double)((DarkDoppelgangerEntity)this.mob).getX(), (double)((DarkDoppelgangerEntity)this.mob).getZ()) + 1.5707964f;
            for (int i = 0; i < count; ++i) {
                Vec3 offset = new Vec3(1.5 * (double)((DarkDoppelgangerEntity)this.mob).getScale(), 0.0, 0.0).zRot(Mth.lerp((float)((float)i / ((float)count - 1.0f)), (float)0.0f, (float)((float)(-Math.PI)))).yRot(yAngle).add(0.0, (double)((DarkDoppelgangerEntity)this.mob).getEyeHeight(), 0.0);
                EnderDaggerEntity dagger = new EnderDaggerEntity(((DarkDoppelgangerEntity)this.mob).level());
                dagger.setOwner((Entity)this.mob);
                dagger.ownerTrack = offset;
                dagger.setTarget((Entity)((DarkDoppelgangerEntity)this.mob).getTarget());
                dagger.setPos(pos.add(offset.yRot(((DarkDoppelgangerEntity)this.mob).getYRot())));
                dagger.delay = delay + i * 2;
                dagger.setDamage((float)(((DarkDoppelgangerEntity)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.75));
                ((DarkDoppelgangerEntity)this.mob).level().addFreshEntity((Entity)dagger);
            }
        }
    }
}

