/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity.ai;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.AnimatedActionGoal;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.EnderDaggerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class EnderDaggerZoneAbilityGoal
extends AnimatedActionGoal<DarkDoppelgangerEntity> {
    public EnderDaggerZoneAbilityGoal(DarkDoppelgangerEntity mob) {
        super((Mob)mob);
    }

    protected boolean canStartAction() {
        return ((DarkDoppelgangerEntity)this.mob).onGround() && !((DarkDoppelgangerEntity)this.mob).isClone && ((DarkDoppelgangerEntity)this.mob).getTarget() != null && ((DarkDoppelgangerEntity)this.mob).distanceToSqr((Entity)((DarkDoppelgangerEntity)this.mob).getTarget()) > 36.0;
    }

    protected int getActionTimestamp() {
        return 1;
    }

    protected int getActionDuration() {
        return 5;
    }

    protected int getCooldown() {
        return Utils.random.nextIntBetweenInclusive(50, 90);
    }

    protected String getAnimationId() {
        return "instant_slash";
    }

    protected void doAction() {
        LivingEntity target = ((DarkDoppelgangerEntity)this.mob).getTarget();
        if (target != null) {
            ((DarkDoppelgangerEntity)this.mob).playSound((SoundEvent)SoundRegistry.MAGIC_ARROW_RELEASE.get(), 2.0f, (float)Utils.random.nextIntBetweenInclusive(80, 110) * 0.01f);
            Vec3 start = ((DarkDoppelgangerEntity)this.mob).getEyePosition();
            Vec3 targetPos = target.position();
            Vec3 deltaAim = targetPos.subtract(start);
            for (int i = 0; i < 3; ++i) {
                Vec3 aim = start.add(deltaAim.yRot(0.7853982f * (float)(i - 1)));
                int delay = Utils.random.nextIntBetweenInclusive(10, 40);
                EnderDaggerEntity dagger = new EnderDaggerEntity(((DarkDoppelgangerEntity)this.mob).level());
                dagger.setOwner((Entity)this.mob);
                dagger.setPos(start);
                dagger.delay = delay;
                dagger.setDamage((float)(((DarkDoppelgangerEntity)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.75));
                dagger.setExplosionRadius(4.0f + Utils.random.nextFloat() * 2.0f);
                dagger.setNoGravity(false);
                Vec3 horizontal = aim.subtract(start).multiply(1.0, 0.0, 1.0);
                double horizontalSpeed = (double)(1.0f * Mth.cos((float)0.7853982f)) + 0.5;
                double distance = horizontal.length();
                double ticks = distance / horizontalSpeed;
                double y1 = aim.y - start.y;
                double g = dagger.getGravity();
                double verticalSpeed = (y1 + 0.5 * g * ticks * ticks) / ticks;
                Vec3 trajectory = horizontal.normalize().scale(horizontalSpeed).add(0.0, verticalSpeed, 0.0);
                dagger.setDeltaMovement(trajectory);
                ((DarkDoppelgangerEntity)this.mob).level().addFreshEntity((Entity)dagger);
            }
        }
    }
}

