/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.event;

import net.bandit.darkdoppelganger.entity.DarkDoppelgangerMinionEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@EventBusSubscriber(modid="darkdoppelganger")
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        AABB box = new AABB(event.getEntity().blockPosition()).inflate(128.0);
        level2.getEntitiesOfClass(DarkDoppelgangerMinionEntity.class, box, e -> true).forEach(Entity::discard);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        AABB box = new AABB(event.getEntity().blockPosition()).inflate(128.0);
        level2.getEntitiesOfClass(DarkDoppelgangerMinionEntity.class, box, e -> true).forEach(Entity::discard);
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        AABB box = new AABB(event.getEntity().blockPosition()).inflate(128.0);
        level2.getEntitiesOfClass(DarkDoppelgangerMinionEntity.class, box, e -> true).forEach(Entity::discard);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        AABB box = new AABB(-3000000.0, -256.0, -3000000.0, 3000000.0, 320.0, 3000000.0);
        level.getEntitiesOfClass(DarkDoppelgangerMinionEntity.class, box, e -> true).forEach(Entity::discard);
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        event.getServer().getAllLevels().forEach(level -> {
            AABB box = new AABB(-3000000.0, -256.0, -3000000.0, 3000000.0, 320.0, 3000000.0);
            level.getEntitiesOfClass(DarkDoppelgangerMinionEntity.class, box, e -> true).forEach(Entity::discard);
        });
    }
}

