/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.items;

import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.bandit.darkdoppelganger.curios.CurioBaseItem;
import net.bandit.darkdoppelganger.registry.SpellRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class DoppelgangerRingItem
extends CurioBaseItem
implements IPresetSpellContainer {
    private static final int BASE_COOLDOWN = 100;
    private static final double HEALTH_BONUS = 20.0;
    protected final int maxSpellSlots;
    List<SpellData> spellData = null;
    SpellDataRegistryHolder[] spellDataRegistryHolders = SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.DOPPEL_PORTAL, 1)});

    public DoppelgangerRingItem(Item.Properties properties) {
        super(properties);
        this.maxSpellSlots = 1;
    }

    public List<SpellData> getSpells() {
        if (this.spellData == null) {
            this.spellData = Arrays.stream(this.spellDataRegistryHolders).map(SpellDataRegistryHolder::getSpellData).toList();
            this.spellDataRegistryHolders = null;
        }
        return this.spellData;
    }

    public boolean tryProcCooldown(Player player) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        player.getCooldowns().addCooldown((Item)this, 100);
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player && (player = (Player)entity).getHealth() < player.getMaxHealth() && player.tickCount % 20 == 0) {
            player.heal(0.5f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.passive_ability", (Object[])new Object[]{5}).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.health_bonus", (Object[])new Object[]{20.0}).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.doppelganger.cooldown_reduction", (Object[])new Object[]{"20%"}).withStyle(ChatFormatting.AQUA));
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (!ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            ISpellContainerMutable spellContainer = ISpellContainer.create((int)1, (boolean)true, (boolean)true).mutableCopy();
            this.getSpells().forEach(spellSlot -> spellContainer.addSpell(spellSlot.getSpell(), spellSlot.getLevel(), true));
            itemStack.set((Supplier)ComponentRegistry.SPELL_CONTAINER, (Object)spellContainer.toImmutable());
        }
    }
}

