/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.spells.NoneSpell;
import java.util.List;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.DarkDoppelgangerMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DarkDoppelgangerMinionEntity
extends AbstractSpellCastingMob
implements Enemy,
IAnimatedAttacker {
    private int age;
    @Nullable
    private UUID summonerUUID;
    RawAnimation animationToPlay = null;
    private final RawAnimation ANIMATION_SPAWN = RawAnimation.begin().thenPlay("join_1");
    private final AnimationController<DarkDoppelgangerMinionEntity> meleeController = new AnimationController((GeoAnimatable)this, "keeper_animations", 0, this::predicate);
    private final AnimationController<DarkDoppelgangerMinionEntity> spawnController = new AnimationController((GeoAnimatable)this, "spawn_animations", 0, this::spawnPredicate);

    public DarkDoppelgangerMinionEntity(EntityType<? extends AbstractSpellCastingMob> type, Level world) {
        super(type, world);
        this.m_6593_((Component)Component.m_237113_((String)"Dark Doppelganger Minion"));
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
    }

    @Nullable
    public ServerPlayer getSummonerPlayer() {
        Level level;
        if (this.summonerUUID == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return serverLevel.m_7654_().m_6846_().m_11259_(this.summonerUUID);
    }

    public void setSummonerUUID(UUID uuid) {
        this.summonerUUID = uuid;
    }

    public boolean m_21532_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.MINION_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.MINION_ATTACK_DAMAGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)Config.MINION_MOVEMENT_SPEED.get()).doubleValue());
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.MINION_ARMOR.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
    }

    protected void m_6668_(DamageSource source) {
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            DarkDoppelgangerMod.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    private PlayState predicate(AnimationState<DarkDoppelgangerMinionEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age > 45 && this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.spawnController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState spawnPredicate(AnimationState<DarkDoppelgangerMinionEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age < 45) {
            controller.setAnimation(this.ANIMATION_SPAWN);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.meleeController});
        controllerRegistrar.add(new AnimationController[]{this.spawnController});
        super.registerControllers(controllerRegistrar);
    }

    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationController.State.STOPPED || this.spawnController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    private List<AbstractSpell> getConfiguredSpells(List<? extends String> ids) {
        return ids.stream().map(ResourceLocation::new).map(SpellRegistry::getSpell).filter(spell -> !(spell instanceof NoneSpell)).toList();
    }

    protected MoveControl createMoveControl() {
        return new MoveControl((Mob)this){

            protected float m_24991_(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                if (d0 * d0 + (d1 = this.f_24977_ - this.f_24974_.m_20189_()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.m_24991_(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.summonerUUID != null) {
            tag.m_128362_("SummonerUUID", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("SummonerUUID")) {
            this.summonerUUID = tag.m_128342_("SummonerUUID");
        }
    }

    public boolean m_8023_() {
        return true;
    }

    protected void m_8099_() {
        this.setFirstPhaseGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void setFirstPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), 3, 6, 100, 250, 1));
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BURNING_DASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())));
        this.f_21345_.m_25352_(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }
}

