/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.event;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.registry.ModSounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonDoppelganger {
    public static int summonDoppelganger(CommandSourceStack source) {
        try {
            ServerLevel serverWorld = source.m_81372_();
            Player nearestPlayer = serverWorld.m_45941_(TargetingConditions.m_148353_().m_26883_(50.0), source.m_81371_().m_7096_(), source.m_81371_().m_7098_(), source.m_81371_().m_7094_());
            if (nearestPlayer == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No players nearby to copy."));
                return 0;
            }
            source.m_288197_(() -> Component.m_237113_((String)("Dark Doppelganger will spawn in 5 seconds, copying " + nearestPlayer.m_7755_().getString() + "!")), true);
            serverWorld.m_7654_().m_18689_(() -> {
                try {
                    Thread.sleep(5000L);
                    serverWorld.m_7654_().execute(() -> {
                        if (nearestPlayer.m_6084_() && nearestPlayer.m_9236_() == serverWorld) {
                            SummonDoppelganger.summonDoppelganger(serverWorld, nearestPlayer);
                        } else {
                            source.m_81352_((Component)Component.m_237113_((String)"Target player is no longer valid."));
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"An error occurred while executing the command."));
            return 0;
        }
    }

    private static void summonDoppelganger(ServerLevel serverWorld, Player player) {
        try {
            if (player == null || !player.m_6084_()) {
                return;
            }
            Vec3 lookVector = player.m_20154_();
            Vec3 spawnPosition = player.m_20182_().m_82549_(lookVector.m_82490_(4.0));
            DarkDoppelgangerEntity entity = new DarkDoppelgangerEntity((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), (Level)serverWorld);
            entity.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
            entity.m_146922_(-player.m_146908_());
            entity.setSummonerPlayer(player);
            entity.m_20049_("dark_doppelganger_boss");
            entity.m_6593_((Component)Component.m_237113_((String)player.m_7755_().getString()));
            entity.m_20340_(true);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            serverWorld.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.BOSS_LAUGH.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            serverWorld.m_7967_((Entity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

