/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.item;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.DarkDoppelgangerMod;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.registry.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowOrbItem
extends Item {
    public ShadowOrbItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        ShadowOrbItem.tagWithThrower(stack, player);
        super.m_7836_(stack, level, player);
        DarkDoppelgangerMod.LOGGER.info("Tagged Shadow Orb with UUID: {}", (Object)player.m_20148_());
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            Player nearest;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!(stack.m_41782_() && stack.m_41783_().m_128403_("ThrowerUUID") || (nearest = level.m_45930_((Entity)entity, 5.0)) == null)) {
                ShadowOrbItem.tagWithThrower(stack, nearest);
                DarkDoppelgangerMod.LOGGER.info("Fallback tagged Shadow Orb with UUID: {}", (Object)nearest.m_20148_());
            }
            if (level.m_46472_() == Level.f_46430_ && entity.m_20186_() < 0.0) {
                UUID throwerId;
                UUID uUID = throwerId = stack.m_41783_() != null && stack.m_41783_().m_128403_("ThrowerUUID") ? stack.m_41783_().m_128342_("ThrowerUUID") : null;
                if (throwerId != null) {
                    Player player = serverLevel.m_46003_(throwerId);
                    if (player != null) {
                        level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.BOSS_LAUGH.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
                        MinecraftServer server = serverLevel.m_7654_();
                        server.execute(() -> server.execute(() -> {
                            try {
                                Thread.sleep(4000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.summonDoppelganger(serverLevel, player);
                        }));
                    } else {
                        DarkDoppelgangerMod.LOGGER.warn("Shadow Orb triggered in void, but thrower not found.");
                    }
                } else {
                    DarkDoppelgangerMod.LOGGER.warn("Shadow Orb triggered in void, but thrower UUID was null.");
                }
                entity.m_146870_();
            }
        }
        return false;
    }

    public static void tagWithThrower(ItemStack stack, Player player) {
        stack.m_41784_().m_128362_("ThrowerUUID", player.m_20148_());
    }

    private void summonDoppelganger(ServerLevel level, Player player) {
        List banned = (List)Config.DOPPELGANGER_BANNED_ARMOR.get();
        Vec3 forward = player.m_20154_().m_82541_().m_82490_(3.0);
        Vec3 spawnPos = player.m_20182_().m_82549_(forward).m_82520_(0.0, 1.0, 0.0);
        BlockPos groundCheck = new BlockPos((int)spawnPos.f_82479_, (int)(spawnPos.f_82480_ - 1.0), (int)spawnPos.f_82481_);
        BlockState stateBelow = level.m_8055_(groundCheck);
        if (stateBelow.m_60795_() || !stateBelow.m_60804_((BlockGetter)level, groundCheck)) {
            spawnPos = player.m_20182_();
        }
        DarkDoppelgangerEntity boss = new DarkDoppelgangerEntity((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), (Level)level);
        boss.m_146884_(spawnPos);
        boss.m_6593_((Component)Component.m_237113_((String)player.m_7755_().getString()));
        boss.m_20340_(true);
        boss.setSummonerPlayer(player);
        boss.m_20049_("dark_doppelganger_boss");
        boss.m_21008_(InteractionHand.MAIN_HAND, player.m_21205_().m_41777_());
        boss.m_21008_(InteractionHand.OFF_HAND, player.m_21206_().m_41777_());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemToEquip;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack playerItem = player.m_6844_(slot);
            boolean isBanned = this.isArmorBanned(playerItem, banned);
            if (!playerItem.m_41619_() && !isBanned) {
                itemToEquip = playerItem.m_41777_();
            } else {
                itemToEquip = switch (slot) {
                    case EquipmentSlot.HEAD -> new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_HELMET.get());
                    case EquipmentSlot.CHEST -> new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_CHESTPLATE.get());
                    case EquipmentSlot.LEGS -> new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_LEGGINGS.get());
                    case EquipmentSlot.FEET -> new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_BOOTS.get());
                    default -> ItemStack.f_41583_;
                };
            }
            boss.m_8061_(slot, itemToEquip);
        }
        if (player.m_21205_().m_41619_()) {
            boss.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemRegistry.ARTIFICER_STAFF.get()));
        } else {
            boss.m_21008_(InteractionHand.MAIN_HAND, player.m_21205_().m_41777_());
        }
        if (player.m_21206_().m_41619_()) {
            boss.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
        } else {
            boss.m_21008_(InteractionHand.OFF_HAND, player.m_21206_().m_41777_());
        }
        level.m_7967_((Entity)boss);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), 30, 0.5, 1.0, 0.5, 0.05);
        level.m_5594_(null, boss.m_20183_(), SoundEvents.f_11851_, SoundSource.HOSTILE, 1.0f, 0.5f);
        DarkDoppelgangerMod.LOGGER.info("Dark Doppelganger summoned for player: {}", (Object)player.m_7755_().getString());
    }

    private boolean isArmorBanned(ItemStack stack, List<? extends String> bannedList) {
        if (stack.m_41619_()) {
            return false;
        }
        String itemId = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
        for (String string : bannedList) {
            if (!(string.endsWith("*") ? itemId.startsWith(string.substring(0, string.length() - 1)) : itemId.equals(string))) continue;
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"\u00a75Throw into the void...").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Only in The End. Something awaits.").m_130940_(ChatFormatting.GRAY));
    }
}

