/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.suspicious_pots.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import xxrexraptorxx.suspicious_pots.main.SuspiciousPots;
import xxrexraptorxx.suspicious_pots.utils.Config;
import xxrexraptorxx.suspicious_pots.utils.SpawnHelper;

@EventBusSubscriber(modid="suspicious_pots")
public class Events {
    @SubscribeEvent
    public static void PotBreakEvent(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().level();
        BlockPos pos = event.getPos();
        Block block = level.getBlockState(pos).getBlock();
        if (Config.getSpawnBlocks().contains(BuiltInRegistries.BLOCK.getKey((Object)block).toString())) {
            ItemStack stack = event.getPlayer().getMainHandItem();
            Block blockBelow = level.getBlockState(pos.below()).getBlock();
            if (stack.is(ItemTags.BREAKS_DECORATED_POTS) && (Config.getBlockWhiteList().isEmpty() || Events.isBlockInWhiteList(blockBelow))) {
                SpawnHelper.SpawnCreature(level, pos);
            }
        }
    }

    private static boolean isBlockInWhiteList(Block block) {
        if (Config.isDebugModeEnabled()) {
            SuspiciousPots.LOGGER.info("Pot placed above: " + BuiltInRegistries.BLOCK.getKey((Object)block).toString());
        }
        for (String validBlock : Config.getBlockWhiteList()) {
            if (!validBlock.equals(BuiltInRegistries.BLOCK.getKey((Object)block).toString())) continue;
            return true;
        }
        return false;
    }
}

