/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.suspicious_pots.utils;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import xxrexraptorxx.suspicious_pots.main.SuspiciousPots;
import xxrexraptorxx.suspicious_pots.utils.Config;

public class SpawnHelper {
    public static void SpawnCreature(Level level, BlockPos pos) {
        if (Config.isDebugModeEnabled()) {
            SuspiciousPots.LOGGER.info("Try to spawn creature!");
        }
        if (!level.isClientSide()) {
            List<String> spawnList = Config.getSpawningList();
            try {
                spawnList.sort(new Comparator<String>(){

                    @Override
                    public int compare(String entry1, String entry2) {
                        try {
                            double spawnProbability1 = Double.parseDouble(entry1.split("-")[1]);
                            double spawnProbability2 = Double.parseDouble(entry2.split("-")[1]);
                            return Double.compare(spawnProbability1, spawnProbability2);
                        }
                        catch (NumberFormatException e) {
                            SuspiciousPots.LOGGER.error("Error parsing spawn probability: " + e.getMessage(), (Throwable)e);
                            return 0;
                        }
                    }
                });
                for (String entry : spawnList) {
                    String[] parts = entry.split("-");
                    if (parts.length != 2) continue;
                    EntityType entityType = EntityType.byString((String)parts[0]).orElse(null);
                    double spawnProbability = Double.parseDouble(parts[1]);
                    double random = Math.random();
                    if (Config.isDebugModeEnabled()) {
                        SuspiciousPots.LOGGER.info("Random [" + (float)random + "] must to be less then spawn probability [" + spawnProbability + " (" + SpawnHelper.ConvertDecimalToPercentage(spawnProbability) + "%) for " + SpawnHelper.EntityTypeNameFormatter(entityType) + "]");
                    }
                    if (entityType == null || !(random < spawnProbability)) continue;
                    if (Config.isDebugModeEnabled()) {
                        SuspiciousPots.LOGGER.info(SpawnHelper.EntityTypeNameFormatter(entityType) + " spawned successfully!");
                    }
                    SpawnHelper.spawnEntityAtLocation(entityType, level, pos);
                    return;
                }
            }
            catch (Exception e) {
                SuspiciousPots.LOGGER.error(e.getMessage());
            }
        }
    }

    private static void spawnEntityAtLocation(EntityType<?> entityType, Level level, BlockPos pos) {
        Entity entity = entityType.create(level, EntitySpawnReason.TRIGGERED);
        if (entity != null) {
            if (entity instanceof AgeableMob) {
                AgeableMob ageableEntity = (AgeableMob)entity;
                ageableEntity.setBaby(true);
            }
            if (entity instanceof Zombie) {
                Zombie zombie = (Zombie)entity;
                zombie.setBaby(true);
            }
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                slime.setSize(1, false);
            }
            if (entity instanceof Silverfish && Config.getSilverfishGroupSpawnProbability() != 0.0) {
                SpawnHelper.SpawnSilverfishGroup(level, pos);
            }
            level.playSound((Entity)((Player)null), pos, SoundEvents.DECORATED_POT_HIT, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.15f + 1.0f);
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    private static void SpawnSilverfishGroup(Level level, BlockPos pos) {
        int searchRadius = 5;
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos block = new BlockPos(posX + x, posY + y, posZ + z);
                    if (level.getBlockState(block).getBlock() != Blocks.DECORATED_POT || pos == block) continue;
                    double random = Math.random();
                    if (Config.isDebugModeEnabled()) {
                        SuspiciousPots.LOGGER.info("Additional silverfish spawning for Pot at the position: [" + block.getX() + ", " + block.getY() + ", " + block.getZ() + "]");
                        SuspiciousPots.LOGGER.info("Random [" + (float)random + "] must to be less then spawn probability [" + Config.getSilverfishGroupSpawnProbability() + " (" + SpawnHelper.ConvertDecimalToPercentage(Config.getSilverfishGroupSpawnProbability()) + "%)]");
                    }
                    if (!(Config.getSilverfishGroupSpawnProbability() > random)) continue;
                    if (Config.isDebugModeEnabled()) {
                        SuspiciousPots.LOGGER.info("Additional silverfish spawned successfully!");
                    }
                    level.playSound((Entity)((Player)null), block, SoundEvents.DECORATED_POT_HIT, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.15f + 1.0f);
                    Silverfish entity = new Silverfish(EntityType.SILVERFISH, level);
                    entity.setPos((double)((float)block.getX() + 0.5f), (double)((float)block.getY() + 1.3f), (double)((float)block.getZ() + 0.5f));
                    level.addFreshEntity((Entity)entity);
                }
            }
        }
    }

    public static double ConvertDecimalToPercentage(double decimal) {
        return decimal > 1.0 ? 100.0 : decimal * 100.0;
    }

    public static String EntityTypeNameFormatter(EntityType entityType) {
        return entityType.toString().replace("entity.", "").replace(".", ":");
    }
}

