/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.butterchat.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen {
    @Unique
    private long animationStartTime = 0L;
    @Unique
    private static final long ANIMATION_DURATION = 300L;
    @Unique
    private boolean isClosing = false;
    @Unique
    private long closeStartTime = 0L;
    @Unique
    private boolean shouldActuallyClose = false;

    protected ChatScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        this.animationStartTime = System.currentTimeMillis();
        this.isClosing = false;
        this.shouldActuallyClose = false;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        float progress;
        long currentTime = System.currentTimeMillis();
        if (this.isClosing) {
            elapsed = currentTime - this.closeStartTime;
            progress = 1.0f - Mth.m_14036_((float)((float)elapsed / 300.0f), (float)0.0f, (float)1.0f);
            if (elapsed >= 300L && !this.shouldActuallyClose) {
                this.shouldActuallyClose = true;
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(null);
                }
                return;
            }
        } else {
            elapsed = currentTime - this.animationStartTime;
            progress = Mth.m_14036_((float)((float)elapsed / 300.0f), (float)0.0f, (float)1.0f);
        }
        float easedProgress = this.isClosing ? this.easeInBack(progress) : this.easeOutBack(progress);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float scale = 0.9f + easedProgress * 0.1f;
        float yOffset = (1.0f - easedProgress) * 30.0f;
        float centerX = (float)this.f_96543_ / 2.0f;
        float bottomY = this.f_96544_;
        poseStack.m_252880_(centerX, bottomY, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_(-centerX, -bottomY + yOffset, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)easedProgress);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onRenderEnd(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRemoved(CallbackInfo ci) {
        if (!this.isClosing && !this.shouldActuallyClose) {
            this.isClosing = true;
            this.closeStartTime = System.currentTimeMillis();
            ci.cancel();
        }
    }

    @Unique
    private float easeOutBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(x - 1.0f, 3.0) + (double)c1 * Math.pow(x - 1.0f, 2.0));
    }

    @Unique
    private float easeInBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)((double)c3 * Math.pow(x, 3.0) - (double)c1 * Math.pow(x, 2.0));
    }
}

