/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.butterchat.mixin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private List<GuiMessage.Line> f_93761_;
    @Shadow
    private int f_93763_;
    @Unique
    private final Map<GuiMessage.Line, Long> lineAnimationTimes = new ConcurrentHashMap<GuiMessage.Line, Long>();
    @Unique
    private static final long MESSAGE_SLIDE_IN_DURATION = 300L;
    @Unique
    private int currentTickCount;
    @Unique
    private int previousTrimmedSize = 0;

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="HEAD")})
    private void beforeMessageAdded(Component message, MessageSignature signature, int ticks, GuiMessageTag tag, boolean refresh, CallbackInfo ci) {
        if (!refresh) {
            this.previousTrimmedSize = this.f_93761_.size();
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="TAIL")})
    private void afterMessageAdded(Component message, MessageSignature signature, int ticks, GuiMessageTag tag, boolean refresh, CallbackInfo ci) {
        if (!refresh) {
            long currentTime = System.currentTimeMillis();
            int currentSize = this.f_93761_.size();
            int newLinesCount = currentSize - this.previousTrimmedSize;
            for (int i = 0; i < newLinesCount && i < this.f_93761_.size(); ++i) {
                GuiMessage.Line line = this.f_93761_.get(i);
                this.lineAnimationTimes.put(line, currentTime);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics guiGraphics, int tickCount, int mouseX, int mouseY, CallbackInfo ci) {
        this.currentTickCount = tickCount;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;III)I"))
    private int redirectDrawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y, int color) {
        GuiMessage.Line currentLine = null;
        for (GuiMessage.Line line : this.f_93761_) {
            if (line.f_240339_() != text) continue;
            currentLine = line;
            break;
        }
        if (currentLine != null) {
            int messageAge;
            boolean isChatOpen;
            Long animStartTime = this.lineAnimationTimes.get(currentLine);
            if (animStartTime != null) {
                long currentTime = System.currentTimeMillis();
                long elapsed = currentTime - animStartTime;
                if (elapsed < 300L) {
                    float progress = (float)elapsed / 300.0f;
                    float easedProgress = this.easeOutCubic(progress);
                    float xOffset = -(1.0f - easedProgress) * 100.0f;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_(xOffset, 0.0f, 0.0f);
                    int alpha = color >> 24 & 0xFF;
                    int rgb = color & 0xFFFFFF;
                    int newAlpha = (int)((float)alpha * easedProgress);
                    color = newAlpha << 24 | rgb;
                    int result = guiGraphics.m_280648_(font, text, x, y, color);
                    guiGraphics.m_280168_().m_85849_();
                    return result;
                }
                this.lineAnimationTimes.remove(currentLine);
            }
            if (!(isChatOpen = Minecraft.m_91087_().f_91080_ instanceof ChatScreen) && (messageAge = this.currentTickCount - currentLine.f_240350_()) > 160 && messageAge <= 200) {
                float fadeProgress = (float)(messageAge - 160) / 40.0f;
                float easedFade = this.easeInCubic(fadeProgress);
                float xOffset = -easedFade * 120.0f;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(xOffset, 0.0f, 0.0f);
                int alpha = color >> 24 & 0xFF;
                int rgb = color & 0xFFFFFF;
                int newAlpha = (int)((float)alpha * (1.0f - fadeProgress));
                color = newAlpha << 24 | rgb;
                int result = guiGraphics.m_280648_(font, text, x, y, color);
                guiGraphics.m_280168_().m_85849_();
                return result;
            }
        }
        return guiGraphics.m_280648_(font, text, x, y, color);
    }

    @Unique
    private float easeOutCubic(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 3.0);
    }

    @Unique
    private float easeInCubic(float x) {
        return (float)Math.pow(x, 3.0);
    }
}

