/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.config.helper;

import com.reggarf.mods.better_lib.config.annotation.ConfigEntry;
import com.reggarf.mods.better_lib.config.gui.BetterConfigScreen;
import com.reggarf.mods.better_lib.config.helper.BetterEntryBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BetterConfigBuilder {
    private final Component title;
    private final List<BetterEntryBuilder> entries = new ArrayList<BetterEntryBuilder>();
    private Screen parent;
    private String background = "minecraft:textures/block/stone.png";

    private BetterConfigBuilder(Component title) {
        this.title = title;
    }

    public static BetterConfigBuilder create(Component title) {
        return new BetterConfigBuilder(title);
    }

    public BetterConfigBuilder setParent(Screen parent) {
        this.parent = parent;
        return this;
    }

    public BetterConfigBuilder setBackground(String texture) {
        this.background = texture;
        return this;
    }

    public BetterEntryBuilder entryBuilder() {
        BetterEntryBuilder builder = new BetterEntryBuilder(this);
        this.entries.add(builder);
        return builder;
    }

    public BetterConfigBuilder autoBuildFrom(Object config) {
        for (Field field : config.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Integer intVal;
                Object value = field.get(config);
                String fieldName = field.getName();
                MutableComponent label = Component.literal((String)fieldName);
                ConfigEntry.Tooltip tooltip = field.getAnnotation(ConfigEntry.Tooltip.class);
                if (tooltip != null) {
                    label = Component.literal((String)(fieldName + " \u00a77(" + tooltip.value() + ")"));
                }
                if (field.isAnnotationPresent(ConfigEntry.BoundedDiscrete.class)) {
                    ConfigEntry.BoundedDiscrete range = field.getAnnotation(ConfigEntry.BoundedDiscrete.class);
                    if (!(value instanceof Integer)) continue;
                    Integer intVal2 = (Integer)value;
                    this.entryBuilder().startIntSlider((Component)label, fieldName, intVal2, range.min(), range.max());
                    continue;
                }
                if (field.isAnnotationPresent(ConfigEntry.Dropdown.class)) {
                    ConfigEntry.Dropdown drop = field.getAnnotation(ConfigEntry.Dropdown.class);
                    if (!(value instanceof String)) continue;
                    String strVal = (String)value;
                    this.entryBuilder().startDropdown((Component)label, fieldName, strVal, drop.values());
                    continue;
                }
                if (field.isAnnotationPresent(ConfigEntry.ColorField.class)) {
                    if (!(value instanceof Integer)) continue;
                    intVal = (Integer)value;
                    this.entryBuilder().startColorPicker((Component)label, fieldName, intVal);
                    continue;
                }
                if (value instanceof Boolean) {
                    Boolean boolVal = (Boolean)value;
                    this.entryBuilder().startBooleanToggle((Component)label, fieldName, boolVal);
                    continue;
                }
                if (value instanceof String) {
                    String strVal = (String)value;
                    this.entryBuilder().startTextField((Component)label, fieldName, strVal);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                intVal = (Integer)value;
                this.entryBuilder().startIntSlider((Component)label, fieldName, intVal, 0, 100);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Screen build(Object config, String name) {
        return new BetterConfigScreen(this.parent, this.title, config, this.entries, name, this.background);
    }
}

