/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.demo;

import com.reggarf.mods.better_lib.config.annotation.Config;
import com.reggarf.mods.better_lib.config.annotation.ConfigEntry;
import com.reggarf.mods.better_lib.config.api.ConfigData;
import java.util.List;

@Config(modid="better_lib", name="common")
public class DemoConfig
implements ConfigData {
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Enable or disable experimental features.")
    public boolean enableFeatureX = true;
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Set your in-game player name for identification.")
    public String playerName = "Reggarf";
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Show developer debug logs in the console.")
    public boolean debugMode = false;
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Auto-save configuration changes on exit.")
    public boolean autoSave = true;
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="How often (in minutes) to check for updates.")
    @ConfigEntry.BoundedDiscrete(min=1, max=120)
    public int updateCheckInterval = 15;
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Choose your preferred language.")
    @ConfigEntry.Dropdown(values={"English", "Spanish", "German", "Hindi", "Japanese"})
    public String language = "English";
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Whether the config screen should use animations.")
    public boolean enableAnimations = true;
    @ConfigEntry.Category(value="General Settings")
    @ConfigEntry.Description(value="Whether to sync this config across multiplayer servers.")
    public boolean syncAcrossServers = false;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Adjust the render distance to balance performance and visuals.")
    @ConfigEntry.BoundedDiscrete(min=2, max=32)
    public int renderDistance = 12;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Enable async loading for world chunks.")
    public boolean asyncChunkLoading = true;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Enable GPU-based rendering optimizations.")
    public boolean gpuOptimizations = true;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Limit FPS to reduce GPU usage.")
    @ConfigEntry.BoundedDiscrete(min=30, max=240)
    public int fpsLimit = 120;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Enable automatic memory cleanup.")
    public boolean memoryCleanup = true;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Set the max entity render count.")
    @ConfigEntry.BoundedDiscrete(min=10, max=500)
    public int maxEntityRender = 200;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Enable smooth lighting.")
    public boolean smoothLighting = true;
    @ConfigEntry.Category(value="Performance")
    @ConfigEntry.Description(value="Enable dynamic shadows (may affect FPS).")
    public boolean dynamicShadows = false;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.ColorField(alpha=true)
    @ConfigEntry.Description(value="UI color theme with optional transparency support.")
    public int uiColor = -2130771968;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.ColorField
    @ConfigEntry.Description(value="Accent color used for buttons.")
    public int accentColor = -16711936;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.ColorField
    @ConfigEntry.Description(value="Background overlay color for GUIs.")
    public int backgroundOverlay = Integer.MIN_VALUE;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.ColorField
    @ConfigEntry.Description(value="Tooltip background color.")
    public int tooltipColor = -870178270;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.Description(value="Enable gradient effects in menus.")
    public boolean enableGradient = true;
    @ConfigEntry.Category(value="Colors")
    @ConfigEntry.Description(value="Select theme style.")
    @ConfigEntry.Dropdown(values={"Default", "Dark", "Light", "Classic", "Cyber"})
    public String theme = "Default";
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Dropdown(values={"EASY", "NORMAL", "HARD"})
    @ConfigEntry.Description(value="Select the overall game difficulty level.")
    public String difficulty = "NORMAL";
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Enable hardcore mode (no respawns).")
    public boolean hardcoreMode = false;
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Enable keep inventory on death.")
    public boolean keepInventory = true;
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Maximum number of tamed pets.")
    @ConfigEntry.BoundedDiscrete(min=1, max=50)
    public int maxPets = 5;
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Enable weather effects (rain, thunder, snow).")
    public boolean weatherEffects = true;
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Respawn delay in seconds after death.")
    @ConfigEntry.BoundedDiscrete(min=1, max=60)
    public int respawnDelay = 5;
    @ConfigEntry.Category(value="Gameplay")
    @ConfigEntry.Description(value="Enable random events in survival mode.")
    public boolean randomEvents = false;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.BoundedDiscrete(min=0, max=100)
    @ConfigEntry.Description(value="Master sound volume.")
    public int masterVolume = 80;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.BoundedDiscrete(min=0, max=100)
    @ConfigEntry.Description(value="Music volume.")
    public int musicVolume = 50;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.BoundedDiscrete(min=0, max=100)
    @ConfigEntry.Description(value="Block interaction sounds.")
    public int blockSoundVolume = 70;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.Description(value="Enable ambient sounds.")
    public boolean ambientSounds = true;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.Description(value="Enable sound when receiving chat messages.")
    public boolean chatPingSound = false;
    @ConfigEntry.Category(value="Audio")
    @ConfigEntry.Description(value="Voice chat quality (requires restart).")
    @ConfigEntry.Dropdown(values={"Low", "Medium", "High", "Ultra"})
    public String voiceChatQuality = "High";
    @ConfigEntry.Category(value="HUD")
    @ConfigEntry.Description(value="Enable custom HUD overlay.")
    public boolean customHUD = true;
    @ConfigEntry.Category(value="HUD")
    @ConfigEntry.Description(value="Show coordinates on screen.")
    public boolean showCoordinates = true;
    @ConfigEntry.Category(value="HUD")
    @ConfigEntry.Description(value="Display FPS counter on screen.")
    public boolean showFPS = true;
    @ConfigEntry.Category(value="HUD")
    @ConfigEntry.Description(value="Show armor durability as a percentage.")
    public boolean showArmorDurability = true;
    @ConfigEntry.Category(value="HUD")
    @ConfigEntry.Description(value="Enable compass direction indicator.")
    public boolean compassEnabled = false;
    @ConfigEntry.Category(value="Chat")
    @ConfigEntry.Description(value="Enable chat formatting.")
    public boolean formattedChat = true;
    @ConfigEntry.Category(value="Chat")
    @ConfigEntry.Description(value="Highlight mentions with color.")
    @ConfigEntry.ColorField
    public int mentionHighlightColor = -22016;
    @ConfigEntry.Category(value="Chat")
    @ConfigEntry.Description(value="Mute system messages.")
    public boolean muteSystemMessages = false;
    @ConfigEntry.Category(value="Chat")
    @ConfigEntry.Description(value="Auto-hide chat after inactivity (seconds).")
    @ConfigEntry.BoundedDiscrete(min=5, max=120)
    public int chatHideDelay = 30;
    @ConfigEntry.Category(value="Chat")
    @ConfigEntry.Description(value="Show timestamp in chat messages.")
    public boolean showChatTimestamp = true;
    @ConfigEntry.Category(value="Misc")
    @ConfigEntry.Description(value="Enable experimental particle effects.")
    public boolean fancyParticles = true;
    @ConfigEntry.Category(value="Misc")
    @ConfigEntry.Description(value="List of custom server IPs.")
    public List<String> favoriteServers = List.of("play.example.net", "mc.reggarf.com");
    @ConfigEntry.Category(value="Misc")
    @ConfigEntry.Description(value="Enable mod compatibility layer.")
    public boolean modCompatibility = true;
    @ConfigEntry.Category(value="Misc")
    @ConfigEntry.Description(value="Show random fun tips on the loading screen.")
    public boolean loadingTips = true;

    @Override
    public void onLoad() {
        System.out.println("[ExampleConfig] Loaded config!");
    }

    @Override
    public void onSave() {
        System.out.println("[ExampleConfig] Saved config!");
    }
}

