/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.config.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.reggarf.mods.better_lib.config.annotation.Config;
import com.reggarf.mods.better_lib.config.annotation.ConfigEntry;
import com.reggarf.mods.better_lib.config.api.ConfigData;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;

public class BetterConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static <T extends ConfigData> T register(Class<T> clazz) {
        try {
            Config configAnnotation = clazz.getAnnotation(Config.class);
            if (configAnnotation == null) {
                throw new IllegalArgumentException("Missing @Config annotation on " + clazz.getName());
            }
            Path file = Path.of("config", configAnnotation.name() + ".json");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            ConfigData configInstance = (ConfigData)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (Files.exists(file, new LinkOption[0])) {
                try (FileReader reader = new FileReader(file.toFile());){
                    JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        String key = field.getName();
                        if (!root.has(key)) continue;
                        JsonElement element = root.get(key);
                        if (element.isJsonObject() && element.getAsJsonObject().has("value")) {
                            element = element.getAsJsonObject().get("value");
                        }
                        BetterConfigManager.setFieldValue(field, configInstance, element);
                    }
                }
            }
            BetterConfigManager.save(configAnnotation.name(), configInstance);
            return (T)configInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load config for " + clazz.getName(), e);
        }
    }

    private static void setFieldValue(Field field, Object config, JsonElement element) throws IllegalAccessException {
        if (element == null || element.isJsonNull()) {
            return;
        }
        Class<?> type = field.getType();
        try {
            if (type == Boolean.TYPE || type == Boolean.class) {
                field.set(config, element.getAsBoolean());
            } else if (type == Integer.TYPE || type == Integer.class) {
                field.set(config, element.getAsInt());
            } else if (type == Double.TYPE || type == Double.class) {
                field.set(config, element.getAsDouble());
            } else if (type == Float.TYPE || type == Float.class) {
                field.set(config, Float.valueOf(element.getAsFloat()));
            } else if (type == Long.TYPE || type == Long.class) {
                field.set(config, element.getAsLong());
            } else if (type == String.class) {
                field.set(config, element.getAsString());
            } else if (List.class.isAssignableFrom(type)) {
                Type genericType = field.getGenericType();
                List list = (List)GSON.fromJson(element, genericType);
                field.set(config, list);
            } else if (type.isArray()) {
                Object array = GSON.fromJson(element, type);
                field.set(config, array);
            } else {
                Object obj = GSON.fromJson(element, type);
                field.set(config, obj);
            }
        }
        catch (JsonSyntaxException e) {
            if (List.class.isAssignableFrom(type) && element.isJsonPrimitive()) {
                String s = element.getAsString();
                List<String> list = Arrays.asList(s.split(","));
                field.set(config, list);
                System.out.println("[BetterConfigManager] Converted old string list for field: " + field.getName());
            }
            throw e;
        }
    }

    public static void save(String name, Object configInstance) {
        try {
            Path file = Path.of("config", name + ".json");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            JsonObject root = new JsonObject();
            Class<?> clazz = configInstance.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(configInstance);
                String category = "General";
                String description = "No description provided.";
                if (field.isAnnotationPresent(ConfigEntry.Category.class)) {
                    category = field.getAnnotation(ConfigEntry.Category.class).value();
                }
                if (field.isAnnotationPresent(ConfigEntry.Description.class)) {
                    description = field.getAnnotation(ConfigEntry.Description.class).value();
                }
                JsonObject entry = new JsonObject();
                if (value instanceof List) {
                    List list = (List)value;
                    entry.add("value", GSON.toJsonTree((Object)list));
                } else if (value != null && value.getClass().isArray()) {
                    entry.add("value", GSON.toJsonTree(value));
                } else if (value instanceof Number) {
                    Number num = (Number)value;
                    entry.addProperty("value", num);
                } else if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    entry.addProperty("value", bool);
                } else if (value != null) {
                    entry.addProperty("value", String.valueOf(value));
                } else {
                    entry.add("value", (JsonElement)JsonNull.INSTANCE);
                }
                entry.addProperty("category", category);
                entry.addProperty("description", description);
                root.add(field.getName(), (JsonElement)entry);
            }
            try (FileWriter writer = new FileWriter(file.toFile());){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            System.out.println("[BetterConfigManager] Saved config file: " + String.valueOf(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

