/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.message.event;

import com.reggarf.mods.better_lib.message.api.JoinMessagePlugin;
import com.reggarf.mods.better_lib.message.api.JoinMessagePlugins;
import com.reggarf.mods.better_lib.message.event.JoinMessageSet;
import java.lang.reflect.Method;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class JoinMessageLib {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompoundTag persistent = player2.getPersistentData();
        CompoundTag tag = JoinMessageLib.getCompoundSafe(persistent, "PlayerPersisted");
        for (JoinMessagePlugin plugin : JoinMessagePlugins.all()) {
            String key;
            if (!plugin.enabled() || JoinMessageLib.getBooleanSafe(tag, key = "joinmsglib_" + plugin.getModId() + "_hasJoinedBefore")) continue;
            for (JoinMessageSet set : plugin.getMessageSets()) {
                set.sendTo(player2);
            }
            JoinMessageLib.putBooleanSafe(tag, key, true);
            JoinMessageLib.putCompoundSafe(persistent, "PlayerPersisted", tag);
        }
    }

    private static CompoundTag getCompoundSafe(CompoundTag tag, String key) {
        try {
            Method m = CompoundTag.class.getMethod("getCompound", String.class);
            return (CompoundTag)m.invoke((Object)tag, key);
        }
        catch (Throwable ignored) {
            try {
                if (((Boolean)CompoundTag.class.getMethod("contains", String.class, Integer.TYPE).invoke((Object)tag, key, 10)).booleanValue()) {
                    return (CompoundTag)CompoundTag.class.getMethod("get", String.class).invoke((Object)tag, key);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new CompoundTag();
        }
    }

    private static boolean getBooleanSafe(CompoundTag tag, String key) {
        try {
            Method m = CompoundTag.class.getMethod("getBoolean", String.class);
            return (Boolean)m.invoke((Object)tag, key);
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = CompoundTag.class.getMethod("getBooleanTag", String.class);
                return (Boolean)m.invoke((Object)tag, key);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void putBooleanSafe(CompoundTag tag, String key, boolean value) {
        try {
            Method m = CompoundTag.class.getMethod("putBoolean", String.class, Boolean.TYPE);
            m.invoke((Object)tag, key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void putCompoundSafe(CompoundTag parent, String key, CompoundTag value) {
        try {
            Method m = CompoundTag.class.getMethod("put", String.class, Tag.class);
            m.invoke((Object)parent, key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

