/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.message.util;

import com.reggarf.mods.better_lib.message.api.OnlineMessagePlugin;
import com.reggarf.mods.better_lib.message.event.OnlineMessageSet;
import com.reggarf.mods.better_lib.message.util.OnlineMessageFetcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="better_lib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OnlineMessageHandler {
    private static final Map<String, OnlineMessageSet> CACHE = new ConcurrentHashMap<String, OnlineMessageSet>();
    private static final Map<String, Boolean> ENABLED = new ConcurrentHashMap<String, Boolean>();

    public static void initializeFor(String modId, OnlineMessagePlugin plugin) {
        boolean enabled = plugin.isOnlineMessageEnabled();
        ENABLED.put(modId, enabled);
        if (!enabled) {
            System.out.println("[BetterLib] Online messages disabled for: " + modId);
            return;
        }
        OnlineMessageSet set = OnlineMessageHandler.fetchAndBuildMessages(plugin);
        CACHE.put(modId, set);
        System.out.println("[BetterLib] Loaded online message set for " + modId);
    }

    public static void refreshMessages(String modId, OnlineMessagePlugin plugin) {
        if (!ENABLED.getOrDefault(modId, true).booleanValue()) {
            return;
        }
        OnlineMessageSet set = OnlineMessageHandler.fetchAndBuildMessages(plugin);
        CACHE.put(modId, set);
        System.out.println("[BetterLib] Refetched online messages for " + modId);
    }

    private static OnlineMessageSet fetchAndBuildMessages(OnlineMessagePlugin plugin) {
        String messageData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getMessageUrl());
        String clickableData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getClickableUrl());
        OnlineMessageSet set = new OnlineMessageSet();
        for (String line : messageData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            set.addText(line, "#FFFFFF");
        }
        for (String line : clickableData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split("\\|");
            String label = parts.length > 0 ? parts[0].trim() : "Link";
            String url = parts.length > 1 ? parts[1].trim() : "";
            String color = parts.length > 2 ? parts[2].trim() : "#00FF00";
            String desc = parts.length > 3 ? parts[3].trim() : "";
            set.addLink(label, url, color, desc);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        for (Map.Entry entry : CACHE.entrySet()) {
            void player3;
            OnlineMessageSet set;
            String modId = (String)entry.getKey();
            if (!ENABLED.getOrDefault(modId, true).booleanValue() || (set = (OnlineMessageSet)entry.getValue()) == null) continue;
            String key = "onlinemsg_seen_" + modId;
            String currentHash = set.hash();
            if (player3.getTags().contains(key + "_" + currentHash)) continue;
            set.sendTo((ServerPlayer)player3);
            player3.getTags().removeIf(tag -> tag.startsWith(key + "_"));
            player3.addTag(key + "_" + currentHash);
        }
    }
}

