/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.config.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.reggarf.mods.better_lib.config.gui.BetterEntryBuilder;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class BetterConfigScreen
extends Screen {
    private final Screen parent;
    private final Object config;
    private final List<BetterEntryBuilder> entries;
    private final String configName;
    private final ResourceLocation background;
    private final List<WidgetData> widgetData = new ArrayList<WidgetData>();
    private ConfigScrollArea scrollArea;

    public BetterConfigScreen(Screen parent, Component title, Object config, List<BetterEntryBuilder> entries, String name, String bgTexture) {
        super(title);
        this.parent = parent;
        this.config = config;
        this.entries = entries;
        this.configName = name;
        this.background = bgTexture != null ? ResourceLocation.tryParse((String)bgTexture) : null;
    }

    protected void init() {
        this.widgetData.clear();
        int panelWidth = 250;
        int panelHeight = this.height - 180;
        int centerX = this.width / 2;
        int panelX = centerX - panelWidth / 2;
        int panelY = 90;
        this.scrollArea = new ConfigScrollArea(panelX, panelY, panelWidth, panelHeight);
        String modid = this.configName != null && !this.configName.isEmpty() ? this.configName : "assets/better_lib";
        int y = 0;
        for (BetterEntryBuilder entry : this.entries) {
            BetterEntryBuilder.EntryData data = entry.build();
            String fieldName = this.sanitizeFieldName(data.label().getString(), modid);
            String labelKey = "config." + modid + "." + fieldName;
            String descriptionKey = labelKey + ".tooltip";
            final Component label = this.getLangOrFallback(labelKey);
            Component tooltipText = this.getTooltipText("General", descriptionKey);
            Object widget = null;
            switch (data.type()) {
                case "bool": {
                    widget = Checkbox.builder((Component)label, (Font)this.font).pos(panelX + 25, 0).selected(((Boolean)data.value()).booleanValue()).build();
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "slider": {
                    final int min = data.min();
                    final int max = data.max();
                    int initial = (Integer)data.value();
                    widget = new AbstractSliderButton(this, panelX + 25, 0, 200, 20, (Component)Component.literal((String)(label.getString() + ": " + initial)), (double)(initial - min) / (double)(max - min)){

                        protected void updateMessage() {
                            int val = (int)((double)min + this.value * (double)(max - min));
                            this.setMessage((Component)Component.literal((String)(label.getString() + ": " + val)));
                        }

                        protected void applyValue() {
                        }
                    };
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "text": {
                    widget = new EditBox(this.font, panelX + 25, 0, 200, 20, label);
                    widget.setValue(data.value().toString());
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "dropdown": {
                    String[] options = data.dropdownValues();
                    String current = data.value().toString();
                    int index = 0;
                    for (int i = 0; i < options.length; ++i) {
                        if (!options[i].equals(current)) continue;
                        index = i;
                    }
                    int[] currentIndex = new int[]{index};
                    widget = Button.builder((Component)Component.literal((String)(label.getString() + ": " + options[currentIndex[0]])), btn -> {
                        currentIndex[0] = (currentIndex[0] + 1) % options.length;
                        btn.setMessage((Component)Component.literal((String)(label.getString() + ": " + options[currentIndex[0]])));
                    }).pos(panelX + 25, 0).size(200, 20).build();
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    this.widgetData.add(new WidgetData(fieldName, "dropdown", widget, options, currentIndex));
                    break;
                }
                case "color": {
                    int color = (Integer)data.value();
                    widget = Button.builder((Component)Component.literal((String)("Color: #" + Integer.toHexString(color).toUpperCase())), btn -> {
                        int newColor = 0xFF000000 | (int)(Math.random() * 1.6777215E7);
                        btn.setMessage((Component)Component.literal((String)("Color: #" + Integer.toHexString(newColor).toUpperCase())));
                        btn.setFGColor(newColor);
                    }).pos(panelX + 25, 0).size(200, 20).build();
                    widget.setFGColor(color);
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                }
            }
            if (widget != null) {
                this.scrollArea.addEntry((AbstractWidget)widget, 28);
                boolean alreadyAdded = this.widgetData.stream().anyMatch(w -> w.fieldName().equals(fieldName));
                if (!alreadyAdded) {
                    this.widgetData.add(new WidgetData(fieldName, data.type(), widget));
                }
            }
            y += 28;
        }
        this.addRenderableWidget((GuiEventListener)this.scrollArea);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udcbe Save & Close"), b -> this.onSave()).pos(centerX - 105, this.height - 50).size(100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2716 Cancel"), b -> this.minecraft.setScreen(this.parent)).pos(centerX + 5, this.height - 50).size(100, 20).build());
    }

    private void onSave() {
        try {
            Class<?> configClass = this.config.getClass();
            for (WidgetData data : this.widgetData) {
                Field field = configClass.getDeclaredField(data.fieldName());
                field.setAccessible(true);
                Object value = null;
                switch (data.type()) {
                    case "bool": {
                        value = ((Checkbox)data.widget()).selected();
                        break;
                    }
                    case "slider": {
                        AbstractSliderButton slider = (AbstractSliderButton)data.widget();
                        String numberPart = slider.getMessage().getString().replaceAll("[^0-9-]", "");
                        value = Integer.parseInt(numberPart);
                        break;
                    }
                    case "text": {
                        value = ((EditBox)data.widget()).getValue();
                        break;
                    }
                    case "dropdown": {
                        value = data.options()[data.selectedIndex()[0]];
                        break;
                    }
                    case "color": {
                        value = ((Button)data.widget()).getFGColor();
                    }
                }
                if (value == null) continue;
                field.set(this.config, value);
            }
            this.saveConfigToFile(this.config, this.configName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minecraft.setScreen(this.parent);
    }

    private void saveConfigToFile(Object config, String name) {
        try {
            File dir = new File(Minecraft.getInstance().gameDirectory, "config");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, name + ".json");
            JsonObject root = new JsonObject();
            String modid = name != null && !name.isEmpty() ? name : "assets/better_lib";
            Class<?> clazz = config.getClass();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object val = field.get(config);
                JsonObject entryObj = new JsonObject();
                if (val instanceof List) {
                    List list = (List)val;
                    entryObj.add("value", gson.toJsonTree((Object)list));
                } else if (val != null && val.getClass().isArray()) {
                    entryObj.add("value", gson.toJsonTree(val));
                } else if (val instanceof Number) {
                    Number n = (Number)val;
                    entryObj.addProperty("value", n);
                } else if (val instanceof Boolean) {
                    Boolean b = (Boolean)val;
                    entryObj.addProperty("value", b);
                } else if (val != null) {
                    entryObj.addProperty("value", String.valueOf(val));
                } else {
                    entryObj.add("value", (JsonElement)JsonNull.INSTANCE);
                }
                root.add(field.getName(), (JsonElement)entryObj);
            }
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson((JsonElement)root, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollArea.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int centerX = this.width / 2;
        if (this.background != null) {
            RenderCompat.enableBlendSafe();
            RenderCompat.setShaderTextureSafe(this.background);
            RenderCompat.blitSafe(graphics, this.background, 0, 0, this.width, this.height, this.width, this.height);
        } else {
            graphics.fillGradient(0, 0, this.width, this.height, -15987700, -14671840);
        }
        int boxWidth = 260;
        int boxHeight = this.height - 160;
        int boxY = 80;
        int padding = 10;
        graphics.fill(centerX - boxWidth / 2 - padding, boxY - padding, centerX + boxWidth / 2 + padding, boxY + boxHeight + padding, -1442840576);
        super.render(graphics, mouseX, mouseY, delta);
        graphics.fill(centerX - boxWidth / 2 - padding, 35, centerX + boxWidth / 2 + padding, 65, -1442840576);
        graphics.fill(centerX - boxWidth / 2 - padding, this.height - 60, centerX + boxWidth / 2 + padding, this.height - 20, -1442840576);
        String modid = this.configName != null && !this.configName.isEmpty() ? this.configName : "assets/better_lib";
        String titleKey = "config." + modid + ".title";
        MutableComponent title = I18n.exists((String)titleKey) ? Component.translatable((String)titleKey) : Component.literal((String)(StringUtils.capitalize((String)modid) + " Config"));
        TitleCompat.drawCenteredTitleSafe(graphics, this.font, (Component)title, centerX, 45, 0xFFFFFF);
    }

    private Component getLangOrFallback(String key) {
        return I18n.exists((String)key) ? Component.translatable((String)key) : Component.literal((String)key);
    }

    private Component getTooltipText(String category, String tooltipKey) {
        String text = I18n.exists((String)tooltipKey) ? I18n.get((String)tooltipKey, (Object[])new Object[0]) : tooltipKey;
        return Component.literal((String)("\u00a7l" + category + "\u00a7r\n" + text));
    }

    private String sanitizeFieldName(String key, String modid) {
        if ((key = key.trim()).startsWith("config." + modid + ".")) {
            key = key.substring(("config." + modid + ".").length());
        }
        if (key.contains(".tooltip")) {
            key = key.replace(".tooltip", "");
        }
        return key.replaceAll("[^A-Za-z0-9_]", "").trim();
    }

    private static class ConfigScrollArea
    extends AbstractWidget {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int scrollOffset = 0;
        private final int entrySpacing = 28;
        private boolean draggingNumeric = false;
        private EditBox draggedBox = null;
        private double lastMouseX = 0.0;
        private int baseValue = 0;

        public ConfigScrollArea(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
        }

        public void addEntry(AbstractWidget widget, int heightStep) {
            this.entries.add(new Entry(widget, heightStep));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            double currentMouseX;
            double diff;
            int startY = this.getY() - this.scrollOffset;
            int visibleBottom = this.getY() + this.getHeight();
            for (Entry entry : this.entries) {
                AbstractWidget widget = entry.widget();
                int widgetY = startY;
                if (widgetY + entry.height() > this.getY() && widgetY < visibleBottom) {
                    widget.setY(widgetY);
                    widget.render(graphics, mouseX, mouseY, partialTick);
                }
                startY += entry.height();
            }
            int contentHeight = this.entries.size() * 28;
            if (contentHeight > this.height) {
                int scrollbarWidth = 6;
                int scrollbarX = this.getX() + this.getWidth() - scrollbarWidth - 2;
                int scrollbarY = this.getY();
                int visibleHeight = this.height;
                float progress = (float)this.scrollOffset / (float)(contentHeight - visibleHeight);
                int thumbHeight = Math.max(16, (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight));
                int thumbY = scrollbarY + (int)((float)(visibleHeight - thumbHeight) * progress);
                graphics.fill(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + visibleHeight, 0x44000000);
                graphics.fill(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -1426063361);
            }
            if (this.draggingNumeric && this.draggedBox != null && Math.abs(diff = (currentMouseX = Minecraft.getInstance().mouseHandler.xpos() / (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() * (double)Minecraft.getInstance().getWindow().getScreenWidth()) - this.lastMouseX) > 0.5) {
                int delta = (int)(diff / 3.0);
                int newValue = this.baseValue + delta;
                this.draggedBox.setValue(String.valueOf(newValue));
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (Entry entry : this.entries) {
                boolean inside;
                AbstractWidget widget = entry.widget();
                boolean bl = inside = mouseX >= (double)widget.getX() && mouseX <= (double)(widget.getX() + widget.getWidth()) && mouseY >= (double)widget.getY() && mouseY <= (double)(widget.getY() + widget.getHeight());
                if (inside) {
                    if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
                    if (widget instanceof EditBox) {
                        EditBox editBox = (EditBox)widget;
                        editBox.setFocused(true);
                        try {
                            Integer.parseInt(editBox.getValue());
                            this.draggingNumeric = true;
                            this.draggedBox = editBox;
                            this.lastMouseX = mouseX;
                            this.baseValue = Integer.parseInt(editBox.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        widget.setFocused(true);
                    }
                    return true;
                }
                widget.setFocused(false);
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            for (Entry entry : this.entries) {
                entry.widget().mouseReleased(mouseX, mouseY, button);
            }
            this.draggingNumeric = false;
            this.draggedBox = null;
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.draggingNumeric || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            for (Entry entry : this.entries) {
                if (!entry.widget().keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return false;
        }

        public boolean charTyped(char codePoint, int modifiers) {
            for (Entry entry : this.entries) {
                if (!entry.widget().charTyped(codePoint, modifiers)) continue;
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            int contentHeight = this.entries.size() * 28;
            int maxScroll = Math.max(0, contentHeight - this.height);
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset - (int)(scrollY * 20.0)), (int)0, (int)maxScroll);
            return true;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private record Entry(AbstractWidget widget, int height) {
        }
    }

    private record WidgetData(String fieldName, String type, Object widget, String[] options, int[] selectedIndex) {
        public WidgetData(String fieldName, String type, Object widget) {
            this(fieldName, type, widget, new String[0], new int[]{0});
        }
    }

    private static class RenderCompat {
        private RenderCompat() {
        }

        public static void enableBlendSafe() {
            try {
                RenderSystem.class.getMethod("defaultBlendFunc", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    RenderSystem.class.getMethod("enableBlend", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void setShaderTextureSafe(ResourceLocation texture) {
            try {
                RenderSystem.class.getMethod("setShaderTexture", ResourceLocation.class).invoke(null, texture);
            }
            catch (NoSuchMethodException e) {
                try {
                    RenderSystem.class.getMethod("setShaderTexture", Integer.TYPE, ResourceLocation.class).invoke(null, 0, texture);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void blitSafe(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int texWidth, int texHeight) {
            try {
                GuiGraphics.class.getMethod("blit", ResourceLocation.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)graphics, texture, x, y, 0, 0, width, height, texWidth, texHeight);
            }
            catch (NoSuchMethodException e) {
                try {
                    GuiGraphics.class.getMethod("blit", ResourceLocation.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)graphics, texture, x, y, Float.valueOf(0.0f), Float.valueOf(0.0f), width, height, texWidth, texHeight);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TitleCompat {
        private TitleCompat() {
        }

        public static void drawCenteredTitleSafe(GuiGraphics graphics, Font font, Component title, int centerX, int y, int color) {
            try {
                graphics.drawCenteredString(font, title, centerX, y, color);
                return;
            }
            catch (Throwable throwable) {
                try {
                    float textWidth = font.width((FormattedText)title);
                    float x = (float)centerX - textWidth / 2.0f;
                    try {
                        Method method = GuiGraphics.class.getMethod("drawString", Font.class, FormattedText.class, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE);
                        method.invoke((Object)graphics, font, title, Float.valueOf(x), Float.valueOf(y), color, false);
                        return;
                    }
                    catch (NoSuchMethodException method) {
                        try {
                            Method method2 = GuiGraphics.class.getMethod("drawString", Font.class, Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                            method2.invoke((Object)graphics, font, title, (int)x, y, color, false);
                            return;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            graphics.drawString(font, title.getString(), (int)x, y, color, false);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

