/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.message.util;

import com.reggarf.mods.better_lib.message.api.OnlineMessagePlugin;
import com.reggarf.mods.better_lib.message.event.OnlineMessageSet;
import com.reggarf.mods.better_lib.message.util.OnlineMessageFetcher;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class OnlineMessageHandler {
    private static final Map<String, OnlineMessageSet> CACHE = new ConcurrentHashMap<String, OnlineMessageSet>();
    private static final Map<String, Boolean> ENABLED = new ConcurrentHashMap<String, Boolean>();

    public static void initializeFor(String modId, OnlineMessagePlugin plugin) {
        boolean enabled = plugin.isOnlineMessageEnabled();
        ENABLED.put(modId, enabled);
        if (!enabled) {
            System.out.println("[BetterLib] Online messages disabled for: " + modId);
            return;
        }
        OnlineMessageSet set = OnlineMessageHandler.fetchAndBuildMessages(plugin);
        CACHE.put(modId, set);
        System.out.println("[BetterLib] Loaded online message set for " + modId);
    }

    public static void refreshMessages(String modId, OnlineMessagePlugin plugin) {
        if (!ENABLED.getOrDefault(modId, true).booleanValue()) {
            return;
        }
        OnlineMessageSet set = OnlineMessageHandler.fetchAndBuildMessages(plugin);
        CACHE.put(modId, set);
        System.out.println("[BetterLib] Refetched online messages for " + modId);
    }

    private static OnlineMessageSet fetchAndBuildMessages(OnlineMessagePlugin plugin) {
        String messageData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getMessageUrl());
        String clickableData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getClickableUrl());
        OnlineMessageSet set = new OnlineMessageSet();
        for (String line : messageData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            set.addText(line, "#FFFFFF");
        }
        for (String line : clickableData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split("\\|");
            String label = parts.length > 0 ? parts[0].trim() : "Link";
            String url = parts.length > 1 ? parts[1].trim() : "";
            String color = parts.length > 2 ? parts[2].trim() : "#00FF00";
            String desc = parts.length > 3 ? parts[3].trim() : "";
            set.addLink(label, url, color, desc);
        }
        return set;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompoundTag data = player2.getPersistentData();
        for (Map.Entry<String, OnlineMessageSet> entry : CACHE.entrySet()) {
            OnlineMessageSet set;
            String modId = entry.getKey();
            if (!ENABLED.getOrDefault(modId, true).booleanValue() || (set = entry.getValue()) == null) continue;
            String key = "lastSeenMessage_" + modId;
            String lastHash = OnlineMessageHandler.safeGetString(data, key);
            String currentHash = set.hash();
            if (currentHash.equals(lastHash)) continue;
            set.sendTo(player2);
            OnlineMessageHandler.safePutString(data, key, currentHash);
        }
    }

    private static String safeGetString(CompoundTag tag, String key) {
        if (tag == null || key == null) {
            return "";
        }
        try {
            if (tag.contains(key, 8)) {
                return tag.getString(key);
            }
        }
        catch (Throwable t) {
            try {
                Tag o = tag.get(key);
                return o instanceof String ? (String)o : "";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    private static void safePutString(CompoundTag tag, String key, String value) {
        if (tag == null || key == null) {
            return;
        }
        try {
            tag.putString(key, value);
        }
        catch (Throwable t) {
            try {
                Method method = tag.getClass().getMethod("put", String.class, Object.class);
                method.invoke((Object)tag, key, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

