/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.enchantment;

import com.mojang.serialization.MapCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import org.jetbrains.annotations.NotNull;

public record BracingEnchantmentEffect() implements EnchantmentEntityEffect
{
    public static final MapCodec<BracingEnchantmentEffect> CODEC = MapCodec.unit(BracingEnchantmentEffect::new);
    private static final float PER_LEVEL_PCT = 0.1f;
    private static final float CAP_PCT = 1.0f;

    public void apply(@NotNull ServerLevel serverLevel, int enchantmentLevel, @NotNull EnchantedItemInUse enchantedItemInUse, @NotNull Entity entity, @NotNull Vec3 vec3) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PlayerHolder holder = PlayerHolder.getOrCreate(player);
        holder.applyBracing(enchantmentLevel, 0.1f, 1.0f);
    }

    public void onDeactivated(EnchantedItemInUse item, Entity entity, Vec3 pos, int enchantmentLevel) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PlayerHolder holder = PlayerHolder.getOrCreate(player);
        holder.clearBracing();
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

