/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.events;

import net.minecraft.world.entity.player.Player;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import net.superscary.heavyinventories.api.player.PlayerWeightCache;

public class PlayerEvents {
    public static void onPlayerTick(Player player) {
        long time = player.level().getGameTime() % 20L;
        if (time == 0L || time == 5L || time == 10L || time == 15L) {
            PlayerWeightCache.markDirty(player);
        }
    }

    public static void playerChangedDimension(Player player) {
        PlayerWeightCache.markDirty(player);
    }

    public static void clone(Player old, Player newPlayer) {
        PlayerWeightCache.remove(old);
        PlayerWeightCache.markDirty(newPlayer);
    }

    public static void onPickupItem(Player player) {
        PlayerWeightCache.markDirty(player);
    }

    public static void onCraft(Player player) {
        PlayerWeightCache.markDirty(player);
    }

    public static void onSmelt(Player player) {
        PlayerWeightCache.markDirty(player);
    }

    public static void onUnequipItem(Player player) {
        PlayerWeightCache.markDirty(player);
        PlayerHolder holder = PlayerHolder.getOrCreate(player);
        holder.clearBracing();
        holder.clearReinforced();
        holder.clearSureFooted();
    }

    public static void logout(Player player) {
        PlayerWeightCache.remove(player);
    }
}

