/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.files;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.superscary.heavyinventories.HeavyInventories;
import net.superscary.heavyinventories.api.files.DataType;

public class ReadFile {
    public static float get(ItemLike item, DataType type) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        return ReadFile.readFromFile(Minecraft.getInstance().gameDirectory.getPath() + "/weights/" + id.getNamespace() + ".json", item, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float readFromFile(String fileName, ItemLike item, DataType type) {
        File file = new File(fileName);
        if (!file.exists()) {
            return 0.1f;
        }
        try (FileReader reader = new FileReader(file);){
            String property;
            ResourceLocation id;
            String field;
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement == null || jsonElement.isJsonNull()) {
                float f = 0.1f;
                return f;
            }
            JsonObject root = jsonElement.getAsJsonObject();
            if (!root.has(field = (id = BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath())) return 0.1f;
            JsonObject fieldObj = root.getAsJsonObject(field);
            if (!fieldObj.has(property = type.name().toLowerCase())) return 0.1f;
            float f = fieldObj.get(property).getAsFloat();
            return f;
        }
        catch (IOException e) {
            HeavyInventories.LOGGER.warn("Failed to read file: {}!", (Object)fileName);
            return 0.1f;
        }
        catch (Exception e) {
            HeavyInventories.LOGGER.warn("Failed to parse JSON file: {}! Error: {}", (Object)fileName, (Object)e.getMessage());
        }
        return 0.1f;
    }
}

