/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.superscary.heavyinventories.api.files.DataType;
import net.superscary.heavyinventories.api.weight.WeightCache;

public class WriteFile {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void writeToFile(String fileName, String field, DataType type, float value) {
        File file = new File(fileName);
        JsonObject root = WriteFile.loadOrCreate(file);
        JsonObject fieldObj = root.has(field) ? root.getAsJsonObject(field) : new JsonObject();
        fieldObj.addProperty(type.name().toLowerCase(), (Number)Float.valueOf(value));
        root.add(field, (JsonElement)fieldObj);
        WriteFile.save(file, root);
    }

    public static void writeToFile(String fileName, String field, Float weight, Float density) {
        JsonObject fieldObj;
        File file = new File(fileName);
        JsonObject root = WriteFile.loadOrCreate(file);
        JsonObject jsonObject = fieldObj = root.has(field) ? root.getAsJsonObject(field) : new JsonObject();
        if (weight != null) {
            fieldObj.addProperty(DataType.WEIGHT.name().toLowerCase(), (Number)weight);
        }
        if (density != null) {
            fieldObj.addProperty(DataType.DENSITY.name().toLowerCase(), (Number)density);
        }
        root.add(field, (JsonElement)fieldObj);
        WriteFile.save(file, root);
    }

    private static JsonObject loadOrCreate(File file) {
        JsonObject jsonObject;
        block13: {
            WriteFile.ensureParentDirectories(file.toPath());
            if (!file.exists()) {
                WriteFile.save(file, new JsonObject());
                return new JsonObject();
            }
            if (file.length() == 0L) {
                return new JsonObject();
            }
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            try {
                JsonObject result = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonObject jsonObject2 = jsonObject = result != null ? result : new JsonObject();
                if (reader == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException e) {
                        return new JsonObject();
                    }
                }
                catch (IOException ioe) {
                    return new JsonObject();
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    private static void save(File file, JsonObject root) {
        Path target = file.toPath();
        try {
            WriteFile.ensureParentDirectories(target);
            File tempPath = new File(target.getParent().toString() + File.pathSeparator + "tmp");
            Path temp = Files.createTempFile(tempPath.toPath(), target.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            Files.move(temp, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            try (BufferedWriter writer = Files.newBufferedWriter(target, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WeightCache.clearAll();
    }

    private static void ensureParentDirectories(Path filePath) throws IOException {
        Path parent = filePath.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

