/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.superscary.heavyinventories.api.player.PlayerWeightCache;
import net.superscary.heavyinventories.api.util.Functions;

public class PlayerHolder {
    private static final float ENCUMBERED_BASE_MULT = 0.25f;
    private static final float SUREFOOTED_OVER_PERLVL = 0.05f;
    private static final float SUREFOOTED_ENC_PERLVL = 0.1f;
    private static final float ENCUMBERED_SWIM_MULT = 0.75f;
    private static final float OVER_ENC_SWIM_MULT = 0.5f;
    private static final float ENCUMBERED_SINK_MULT = 1.5f;
    private static final float OVER_ENC_SINK_MULT = 3.0f;
    private static List<PlayerHolder> PLAYERS = new ArrayList<PlayerHolder>();
    private static float STARTING_WEIGHT = 1000.0f;
    private final Player player;
    private float weight;
    private float maxWeight;
    private boolean encumbered;
    private boolean overEncumbered;
    private float bracingOffset;
    private int bracingAppliedLevel;
    private float reinforcedOffset;
    private int reinforcedAppliedLevel;
    private int sureFootedAppliedLevel = 0;
    private float sureFootedMult = 1.0f;

    public PlayerHolder(Player player) {
        this.player = player;
        this.weight = 0.0f;
        this.maxWeight = STARTING_WEIGHT;
        this.encumbered = false;
        this.overEncumbered = false;
        this.bracingOffset = 0.0f;
        this.reinforcedOffset = 0.0f;
    }

    public void update() {
        this.setWeight(PlayerWeightCache.getOrCompute(this.getPlayer()));
        this.encumbered = this.isEncumbered();
        this.overEncumbered = this.isOverEncumbered();
    }

    public Player getPlayer() {
        return this.player;
    }

    public float getWeight() {
        return this.weight;
    }

    public float setWeight(float weight) {
        this.weight = weight;
        return weight;
    }

    public float setMaxWeight(float maxWeight) {
        this.maxWeight = maxWeight;
        return maxWeight;
    }

    public float getMaxWeight() {
        return this.maxWeight + this.getBracingOffset() + this.getReinforcedOffset();
    }

    public float getBaseMaxWeight() {
        return this.maxWeight;
    }

    public void setBracingOffset(float offset) {
        this.bracingOffset = offset;
    }

    public void addWeightOffset(float offset) {
        this.bracingOffset += offset;
    }

    public float getBracingOffset() {
        return this.bracingOffset;
    }

    public float getReinforcedOffset() {
        return this.reinforcedOffset;
    }

    public boolean isEncumbered() {
        if (this.getPlayer().isCreative()) {
            return false;
        }
        if (this.hasStrength()) {
            return this.getEncumberedPercentage() >= 100.0f && this.getEncumberedPercentage() < 110.0f;
        }
        return this.getEncumberedPercentage() >= 90.0f && this.getEncumberedPercentage() < 100.0f;
    }

    public boolean isOverEncumbered() {
        if (this.getPlayer().isCreative()) {
            return false;
        }
        if (this.hasStrength()) {
            return this.getEncumberedPercentage() >= 115.0f && this.getEncumberedPercentage() < 125.0f;
        }
        return this.getEncumberedPercentage() >= 100.0f;
    }

    private boolean hasStrength() {
        return this.getPlayer().hasEffect(MobEffects.DAMAGE_BOOST);
    }

    public float getEncumberedPercentage() {
        return this.getWeight() / this.getMaxWeight() * 100.0f;
    }

    public float getFluidSwimMultiplier() {
        if (this.isOverEncumbered()) {
            return 0.5f;
        }
        if (this.isEncumbered()) {
            return 0.75f;
        }
        return 1.0f;
    }

    public float getFluidSinkGravityMultiplier() {
        if (this.isOverEncumbered()) {
            return 3.0f;
        }
        if (this.isEncumbered()) {
            return 1.5f;
        }
        return 1.0f;
    }

    public void applyBracing(int level, float perLevelPct, float capPct) {
        if (level < 0) {
            level = 0;
        }
        if (level == this.bracingAppliedLevel) {
            return;
        }
        this.addWeightOffset(-this.bracingOffset);
        float base = this.getBaseMaxWeight();
        float pct = Math.min(perLevelPct * (float)level, capPct);
        float offset = base * pct;
        this.addWeightOffset(offset);
        this.bracingOffset = offset;
        this.bracingAppliedLevel = level;
    }

    public void clearBracing() {
        this.addWeightOffset(-this.bracingOffset);
        this.bracingOffset = 0.0f;
        this.bracingAppliedLevel = 0;
    }

    public void applyReinforced(int level, float perLevelPct, float capPct) {
        if (level < 0) {
            level = 0;
        }
        if (level == this.reinforcedAppliedLevel) {
            return;
        }
        this.addWeightOffset(-this.reinforcedOffset);
        float base = this.getBaseMaxWeight();
        float pct = Math.min(perLevelPct * (float)level, capPct);
        float offset = base * pct;
        this.addWeightOffset(offset);
        this.reinforcedOffset = offset;
        this.reinforcedAppliedLevel = level;
    }

    public void clearReinforced() {
        this.addWeightOffset(-this.reinforcedOffset);
        this.reinforcedOffset = 0.0f;
        this.reinforcedAppliedLevel = 0;
    }

    public void applySureFooted(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level == this.sureFootedAppliedLevel) {
            return;
        }
        this.sureFootedAppliedLevel = level;
        float base = Functions.either(this.isOverEncumbered(), Float.valueOf(0.0f), Functions.either(this.isEncumbered(), Float.valueOf(0.25f), Float.valueOf(1.0f))).floatValue();
        float floor = Functions.either(this.isOverEncumbered(), Float.valueOf(0.1f * (float)level), Functions.either(this.isEncumbered(), Float.valueOf(0.1f * (float)level), Float.valueOf(1.0f))).floatValue();
        this.sureFootedMult = Math.min(1.0f, Math.max(base, floor));
    }

    public void clearSureFooted() {
        this.sureFootedMult = 1.0f;
        this.sureFootedAppliedLevel = 0;
    }

    public float getSureFootedMult() {
        return this.sureFootedMult;
    }

    public static List<PlayerHolder> getPlayers() {
        return PLAYERS;
    }

    public static PlayerHolder getOrCreate(Player player) {
        for (PlayerHolder playerHolder : PLAYERS) {
            if (!playerHolder.getPlayer().getUUID().equals(player.getUUID())) continue;
            return playerHolder;
        }
        PlayerHolder playerHolder = new PlayerHolder(player);
        PLAYERS.add(playerHolder);
        return playerHolder;
    }

    public static void setWeightStarting(float startingWeight) {
        STARTING_WEIGHT = startingWeight;
    }
}

