/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.player;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import net.superscary.heavyinventories.api.weight.CalculateWeight;

public final class PlayerWeightCache {
    private static final Map<UUID, Entry> CACHE = new ConcurrentHashMap<UUID, Entry>();

    private PlayerWeightCache() {
    }

    public static float getOrCompute(Player player) {
        float w;
        UUID id = player.getUUID();
        Entry entry = CACHE.computeIfAbsent(id, k -> new Entry());
        int fp = PlayerWeightCache.fingerprint(player);
        if (!entry.dirty && entry.lastFingerprint == fp) {
            return entry.weight;
        }
        entry.weight = w = CalculateWeight.from(player);
        entry.lastFingerprint = fp;
        entry.dirty = false;
        return w;
    }

    public static void markDirty(Player player) {
        PlayerWeightCache.CACHE.computeIfAbsent((UUID)player.getUUID(), (Function<UUID, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$markDirty$1(java.util.UUID ), (Ljava/util/UUID;)Lnet/superscary/heavyinventories/api/player/PlayerWeightCache$Entry;)()).dirty = true;
        PlayerHolder.getOrCreate(player).update();
    }

    public static void clearAll() {
        CACHE.clear();
    }

    public static void remove(Player player) {
        CACHE.remove(player.getUUID());
    }

    private static int fingerprint(Player p) {
        int h = 1;
        for (ItemStack s : p.getInventory().items) {
            h = PlayerWeightCache.mix(h, s);
        }
        for (ItemStack s : p.getInventory().armor) {
            h = PlayerWeightCache.mix(h, s);
        }
        for (ItemStack s : p.getInventory().offhand) {
            h = PlayerWeightCache.mix(h, s);
        }
        return h;
    }

    private static int mix(int h, ItemStack s) {
        if (s.isEmpty()) {
            return h * 31 + 1;
        }
        int x = System.identityHashCode(s.getItem());
        x = 31 * x + s.getCount();
        if (s.isDamageableItem()) {
            x = 31 * x + s.getDamageValue();
        }
        return 31 * h + x;
    }

    private static /* synthetic */ Entry lambda$markDirty$1(UUID k) {
        return new Entry();
    }

    private static final class Entry {
        volatile float weight = 0.0f;
        volatile int lastFingerprint = 0;
        volatile boolean dirty = true;

        private Entry() {
        }
    }
}

