/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public interface IResourceList {
    public Collection<HashMap<ItemLike, Integer>> getResources();

    public static IResourceList getResourceList(ItemLike itemLike, Level level) {
        ArrayList<HashMap<ItemLike, Integer>> resources = new ArrayList<HashMap<ItemLike, Integer>>();
        resources.addAll(IResourceList.getCraftingTableList(itemLike, level).getResources());
        resources.addAll(IResourceList.getSmeltingList(itemLike, level).getResources());
        resources.addAll(IResourceList.getBlastingList(itemLike, level).getResources());
        resources.addAll(IResourceList.getSmokingList(itemLike, level).getResources());
        resources.addAll(IResourceList.getSmithingList(itemLike, level).getResources());
        return () -> resources;
    }

    public static IResourceList getCraftingTableList(ItemLike itemLike, Level level) {
        ArrayList resources = new ArrayList();
        RegistryAccess access = level.registryAccess();
        List<RecipeHolder> matches = level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(r -> {
            ItemStack out = ((CraftingRecipe)r.value()).getResultItem((HolderLookup.Provider)access);
            return out.is(itemLike.asItem());
        }).toList();
        for (RecipeHolder match : matches) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((CraftingRecipe)match.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    map.merge(item, 1, Integer::sum);
                }
            }
            resources.add(map);
        }
        return () -> resources;
    }

    public static IResourceList getSmeltingList(ItemLike itemLike, Level level) {
        ArrayList resources = new ArrayList();
        RegistryAccess access = level.registryAccess();
        List<RecipeHolder> matches = level.getRecipeManager().getAllRecipesFor(RecipeType.SMELTING).stream().filter(r -> {
            ItemStack out = ((SmeltingRecipe)r.value()).getResultItem((HolderLookup.Provider)access);
            return out.is(itemLike.asItem());
        }).toList();
        for (RecipeHolder match : matches) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((SmeltingRecipe)match.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    map.merge(item, 1, Integer::sum);
                }
            }
            resources.add(map);
        }
        return () -> resources;
    }

    public static IResourceList getBlastingList(ItemLike itemLike, Level level) {
        ArrayList resources = new ArrayList();
        RegistryAccess access = level.registryAccess();
        List<RecipeHolder> matches = level.getRecipeManager().getAllRecipesFor(RecipeType.BLASTING).stream().filter(r -> {
            ItemStack out = ((BlastingRecipe)r.value()).getResultItem((HolderLookup.Provider)access);
            return out.is(itemLike.asItem());
        }).toList();
        for (RecipeHolder match : matches) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((BlastingRecipe)match.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    map.merge(item, 1, Integer::sum);
                }
            }
            resources.add(map);
        }
        return () -> resources;
    }

    public static IResourceList getSmokingList(ItemLike itemLike, Level level) {
        ArrayList resources = new ArrayList();
        RegistryAccess access = level.registryAccess();
        List<RecipeHolder> matches = level.getRecipeManager().getAllRecipesFor(RecipeType.SMOKING).stream().filter(r -> {
            ItemStack out = ((SmokingRecipe)r.value()).getResultItem((HolderLookup.Provider)access);
            return out.is(itemLike.asItem());
        }).toList();
        for (RecipeHolder match : matches) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((SmokingRecipe)match.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    map.merge(item, 1, Integer::sum);
                }
            }
            resources.add(map);
        }
        return () -> resources;
    }

    public static IResourceList getSmithingList(ItemLike itemLike, Level level) {
        ArrayList resources = new ArrayList();
        RegistryAccess access = level.registryAccess();
        List<RecipeHolder> matches = level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING).stream().filter(r -> {
            ItemStack out = ((SmithingRecipe)r.value()).getResultItem((HolderLookup.Provider)access);
            return out.is(itemLike.asItem());
        }).toList();
        for (RecipeHolder match : matches) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((SmithingRecipe)match.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    map.merge(item, 1, Integer::sum);
                }
            }
            resources.add(map);
        }
        return () -> resources;
    }
}

